/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.IsSingleton;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.support.PollingConsumerSupport;
import org.apache.camel.support.service.ServiceHelper;

public class ProcessorPollingConsumer
extends PollingConsumerSupport
implements IsSingleton {
    private final Processor processor;

    public ProcessorPollingConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint);
        this.processor = processor;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.processor);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.processor);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    public Exchange receive() {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(String.valueOf((Object)this) + " is not started, but in state: " + this.getStatus().name());
        }
        Exchange exchange = this.getEndpoint().createExchange();
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Error while processing exchange", exchange, (Throwable)e);
        }
        return exchange;
    }

    public Exchange receiveNoWait() {
        return this.receive();
    }

    public Exchange receive(long timeout) {
        return this.receive();
    }

    public boolean isSingleton() {
        return true;
    }
}

