/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.saga;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.saga.InMemorySagaService;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemorySagaCoordinator
implements CamelSagaCoordinator {
    private static final Logger LOG = LoggerFactory.getLogger(InMemorySagaCoordinator.class);
    private final CamelContext camelContext;
    private final InMemorySagaService sagaService;
    private final String sagaId;
    private final List<CamelSagaStep> steps;
    private final Map<CamelSagaStep, Map<String, Object>> optionValues;
    private final AtomicReference<Status> currentStatus;

    public InMemorySagaCoordinator(CamelContext camelContext, InMemorySagaService sagaService, String sagaId) {
        this.camelContext = (CamelContext)ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.sagaService = (InMemorySagaService)ObjectHelper.notNull((Object)sagaService, (String)"sagaService");
        this.sagaId = (String)ObjectHelper.notNull((Object)sagaId, (String)"sagaId");
        this.steps = new CopyOnWriteArrayList<CamelSagaStep>();
        this.optionValues = new ConcurrentHashMap<CamelSagaStep, Map<String, Object>>();
        this.currentStatus = new AtomicReference<Status>(Status.RUNNING);
    }

    public String getId() {
        return this.sagaId;
    }

    @Override
    public CompletableFuture<Void> beginStep(Exchange exchange, CamelSagaStep step) {
        Status status = this.currentStatus.get();
        if (status != Status.RUNNING) {
            CompletableFuture<Void> res = new CompletableFuture<Void>();
            res.completeExceptionally(new IllegalStateException("Cannot begin: status is " + status));
            return res;
        }
        this.steps.add(step);
        if (!step.getOptions().isEmpty()) {
            this.optionValues.putIfAbsent(step, new ConcurrentHashMap());
            Map<String, Object> values = this.optionValues.get(step);
            for (String option : step.getOptions().keySet()) {
                Expression expression = step.getOptions().get(option);
                try {
                    values.put(option, expression.evaluate(exchange, Object.class));
                }
                catch (Exception ex) {
                    return CompletableFuture.supplyAsync(() -> {
                        throw new RuntimeCamelException("Cannot evaluate saga option '" + option + "'", (Throwable)ex);
                    });
                }
            }
        }
        if (step.getTimeoutInMilliseconds().isPresent()) {
            this.sagaService.getExecutorService().schedule(() -> {
                boolean doAction = this.currentStatus.compareAndSet(Status.RUNNING, Status.COMPENSATING);
                if (doAction) {
                    this.doCompensate();
                }
            }, (long)step.getTimeoutInMilliseconds().get(), TimeUnit.MILLISECONDS);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> compensate(Exchange exchange) {
        boolean doAction = this.currentStatus.compareAndSet(Status.RUNNING, Status.COMPENSATING);
        if (doAction) {
            this.doCompensate();
        } else {
            Status status = this.currentStatus.get();
            if (status != Status.COMPENSATING && status != Status.COMPENSATED) {
                CompletableFuture<Void> res = new CompletableFuture<Void>();
                res.completeExceptionally(new IllegalStateException("Cannot compensate: status is " + status));
                return res;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> complete(Exchange exchange) {
        boolean doAction = this.currentStatus.compareAndSet(Status.RUNNING, Status.COMPLETING);
        if (doAction) {
            this.doComplete();
        } else {
            Status status = this.currentStatus.get();
            if (status != Status.COMPLETING && status != Status.COMPLETED) {
                CompletableFuture<Void> res = new CompletableFuture<Void>();
                res.completeExceptionally(new IllegalStateException("Cannot complete: status is " + status));
                return res;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Boolean> doCompensate() {
        return this.doFinalize(CamelSagaStep::getCompensation, "compensation").thenApply(res -> {
            this.currentStatus.set(Status.COMPENSATED);
            return res;
        });
    }

    public CompletableFuture<Boolean> doComplete() {
        return this.doFinalize(CamelSagaStep::getCompletion, "completion").thenApply(res -> {
            this.currentStatus.set(Status.COMPLETED);
            return res;
        });
    }

    public CompletableFuture<Boolean> doFinalize(Function<CamelSagaStep, Optional<Endpoint>> endpointExtractor, String description) {
        CompletionStage<Boolean> result = CompletableFuture.completedFuture(true);
        for (CamelSagaStep step : this.reversed(this.steps)) {
            Optional<Endpoint> endpoint = endpointExtractor.apply(step);
            if (!endpoint.isPresent()) continue;
            result = result.thenCompose(prevResult -> this.doFinalize((Endpoint)endpoint.get(), step, 0, description).thenApply(res -> prevResult != false && res != false));
        }
        return result.whenComplete((done, ex) -> {
            if (ex != null) {
                LOG.error("Cannot finalize {} the saga", (Object)description, ex);
            } else if (!done.booleanValue()) {
                LOG.warn("Unable to finalize {} for all required steps of the saga {}", (Object)description, (Object)this.sagaId);
            }
        });
    }

    private CompletableFuture<Boolean> doFinalize(Endpoint endpoint, CamelSagaStep step, int doneAttempts, String description) {
        Exchange exchange = this.createExchange(endpoint, step);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Exchange res = this.camelContext.createFluentProducerTemplate().to(endpoint).withExchange(exchange).send();
            Exception ex = res.getException();
            if (ex != null) {
                throw new RuntimeCamelException((Throwable)res.getException());
            }
            return true;
        }, this.sagaService.getExecutorService()).exceptionally(ex -> {
            LOG.warn("Exception thrown during {} at {}. Attempt {} of {}", new Object[]{description, endpoint.getEndpointUri(), doneAttempts + 1, this.sagaService.getMaxRetryAttempts(), ex});
            return false;
        })).thenCompose(executed -> {
            int currentAttempt = doneAttempts + 1;
            if (executed.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            if (currentAttempt >= this.sagaService.getMaxRetryAttempts()) {
                return CompletableFuture.completedFuture(false);
            }
            CompletableFuture future = new CompletableFuture();
            this.sagaService.getExecutorService().schedule(() -> this.doFinalize(endpoint, step, currentAttempt, description).whenComplete((res, ex) -> {
                if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                } else {
                    future.complete(res);
                }
            }), this.sagaService.getRetryDelayInMilliseconds(), TimeUnit.MILLISECONDS);
            return future;
        });
    }

    private Exchange createExchange(Endpoint endpoint, CamelSagaStep step) {
        Exchange exchange = endpoint.createExchange();
        exchange.getIn().setHeader("Long-Running-Action", (Object)this.getId());
        Map<String, Object> values = this.optionValues.get(step);
        if (values != null) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                exchange.getIn().setHeader(entry.getKey(), entry.getValue());
            }
        }
        return exchange;
    }

    private <T> List<T> reversed(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    private static enum Status {
        RUNNING,
        COMPENSATING,
        COMPENSATED,
        COMPLETING,
        COMPLETED;

    }
}

