/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.Route;
import org.apache.camel.StreamCache;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.trait.message.MessageTrait;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;

public final class MessageHelper {
    private static final String MESSAGE_HISTORY_HEADER = "%-40s %-30s %-50s %-12s";
    private static final String MESSAGE_HISTORY_OUTPUT = "%-40.40s %-30.30s %-50.50s %12.12s";

    private MessageHelper() {
    }

    public static String extractBodyAsString(Message message) {
        Object answer;
        if (message == null) {
            return null;
        }
        Object body = message.getBody();
        if (body instanceof String) {
            return (String)body;
        }
        StreamCache newBody = (StreamCache)message.getExchange().getContext().getTypeConverter().tryConvertTo(StreamCache.class, message.getExchange(), body);
        if (newBody != null) {
            message.setBody((Object)newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer != null ? answer.toString() : null;
    }

    public static String getBodyTypeName(Message message) {
        if (message == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName((Object)message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    public static void resetStreamCache(Message message) {
        if (message == null) {
            return;
        }
        Object body = null;
        try {
            body = message.getBody();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (body instanceof StreamCache) {
            ((StreamCache)body).reset();
        }
    }

    public static String getContentType(Message message) {
        return (String)message.getHeader("Content-Type", String.class);
    }

    public static String getContentEncoding(Message message) {
        return (String)message.getHeader("Content-Encoding", String.class);
    }

    public static String extractBodyForLogging(Message message) {
        return MessageHelper.extractBodyForLogging(message, "Message: ");
    }

    public static String extractValueForLogging(Object value, Message message) {
        String property;
        boolean streams = MessageHelper.isStreams(message);
        int maxChars = 1000;
        if (message.getExchange() != null && (property = message.getExchange().getContext().getGlobalOption("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = (Integer)message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, (Object)property);
        }
        return MessageHelper.extractValueForLogging(value, message, streams, false, maxChars);
    }

    private static boolean isStreams(Message message) {
        String globalOption;
        boolean streams = false;
        if (message.getExchange() != null && (globalOption = message.getExchange().getContext().getGlobalOption("CamelLogDebugStreams")) != null) {
            streams = (Boolean)message.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, message.getExchange(), (Object)globalOption);
        }
        return streams;
    }

    public static String extractBodyForLogging(Message message, String prepend) {
        boolean streams = MessageHelper.isStreams(message);
        return MessageHelper.extractBodyForLogging(message, prepend, streams, false);
    }

    public static String extractBodyForLogging(Message message, String prepend, boolean allowStreams, boolean allowFiles) {
        String globalOption;
        int maxChars = 1000;
        if (message.getExchange() != null && (globalOption = message.getExchange().getContext().getGlobalOption("CamelLogDebugBodyMaxChars")) != null) {
            maxChars = (Integer)message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, (Object)globalOption);
        }
        return MessageHelper.extractBodyForLogging(message, prepend, allowStreams, allowFiles, maxChars);
    }

    public static String extractBodyForLogging(Message message, String prepend, boolean allowStreams, boolean allowFiles, int maxChars) {
        String value = MessageHelper.extractValueForLogging(message.getBody(), message, allowStreams, allowFiles, maxChars);
        if (prepend != null) {
            return prepend + value;
        }
        return value;
    }

    public static String extractBodyForLogging(Message message, String prepend, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars) {
        String value = MessageHelper.extractValueForLogging(message.getBody(), message, allowCachedStreams, allowStreams, allowFiles, maxChars);
        if (prepend != null) {
            return prepend + value;
        }
        return value;
    }

    public static String extractValueForLogging(Object obj, Message message, boolean allowStreams, boolean allowFiles, int maxChars) {
        return MessageHelper.extractValueForLogging(obj, message, allowStreams, allowStreams, allowFiles, maxChars);
    }

    public static String extractValueForLogging(Object obj, Message message, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars) {
        if (maxChars < 0) {
            return "[Body is not logged]";
        }
        if (obj == null) {
            return "[Body is null]";
        }
        if (!allowFiles && (obj instanceof WrappedFile || obj instanceof File)) {
            return "[Body is file based: " + obj + "]";
        }
        if (!allowStreams) {
            boolean allow;
            boolean bl = allow = allowCachedStreams && obj instanceof StreamCache;
            if (!allow) {
                if (obj instanceof StreamCache) {
                    return "[Body is instance of org.apache.camel.StreamCache]";
                }
                if (obj instanceof InputStream) {
                    return "[Body is instance of java.io.InputStream]";
                }
                if (obj instanceof OutputStream) {
                    return "[Body is instance of java.io.OutputStream]";
                }
                if (obj instanceof Reader) {
                    return "[Body is instance of java.io.Reader]";
                }
                if (obj instanceof Writer) {
                    return "[Body is instance of java.io.Writer]";
                }
                if (obj.getClass().getName().equals("javax.xml.transform.stax.StAXSource")) {
                    return "[Body is instance of javax.xml.transform.Source]";
                }
            }
        }
        StreamCache cache = null;
        InputStream is = null;
        if (obj instanceof StreamCache) {
            cache = (StreamCache)obj;
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        }
        Object body = null;
        if (message.getExchange() != null) {
            try {
                body = (String)message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (body == null) {
            try {
                body = obj.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cache != null) {
            cache.reset();
        } else if (is != null && is.markSupported()) {
            try {
                is.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (body == null) {
            return "[Body is null]";
        }
        if (maxChars > 0 && ((String)body).length() > maxChars) {
            body = ((String)body).substring(0, maxChars) + "... [Body clipped after " + maxChars + " chars, total length is " + ((String)body).length() + "]";
        }
        return body;
    }

    public static String dumpAsXml(Message message) {
        return MessageHelper.dumpAsXml(message, true);
    }

    public static String dumpAsXml(Message message, boolean includeBody) {
        return MessageHelper.dumpAsXml(message, includeBody, 0);
    }

    public static String dumpAsXml(Message message, boolean includeBody, int indent) {
        return MessageHelper.dumpAsXml(message, includeBody, indent, false, true, 131072);
    }

    public static String dumpAsXml(Message message, boolean includeBody, int indent, boolean allowStreams, boolean allowFiles, int maxChars) {
        return MessageHelper.dumpAsXml(message, false, includeBody, indent, allowStreams, allowStreams, allowFiles, maxChars);
    }

    public static String dumpAsXml(Message message, boolean includeExchangeProperties, boolean includeBody, int indent, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars) {
        StringBuilder sb = new StringBuilder();
        StringBuilder prefix = new StringBuilder();
        prefix.append(" ".repeat(indent));
        sb.append((CharSequence)prefix);
        String messageType = ObjectHelper.classCanonicalName((Object)message);
        String exchangeType = ObjectHelper.classCanonicalName((Object)message.getExchange());
        sb.append("<message exchangeId=\"").append(message.getExchange().getExchangeId()).append("\" exchangePattern=\"").append(message.getExchange().getPattern().name()).append("\" exchangeType=\"").append(exchangeType).append("\" messageType=\"").append(messageType).append("\">\n");
        if (includeExchangeProperties && message.getExchange().hasProperties()) {
            sb.append((CharSequence)prefix);
            sb.append("  <exchangeProperties>\n");
            TreeMap properties = new TreeMap(message.getExchange().getAllProperties());
            for (Map.Entry entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if ("CamelMessageHistory".equals(key)) continue;
                Object value = entry.getValue();
                String type = ObjectHelper.classCanonicalName(value);
                sb.append((CharSequence)prefix);
                sb.append("    <exchangeProperty key=\"").append(key).append("\"");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                if (value != null) {
                    try {
                        String xml = (String)message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), value);
                        if (xml != null) {
                            sb.append(StringHelper.xmlEncode((String)xml));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sb.append("</exchangeProperty>\n");
            }
            sb.append((CharSequence)prefix);
            sb.append("  </exchangeProperties>\n");
        }
        if (message.hasHeaders()) {
            sb.append((CharSequence)prefix);
            sb.append("  <headers>\n");
            TreeMap headers = new TreeMap(message.getHeaders());
            for (Map.Entry entry : headers.entrySet()) {
                Object value = entry.getValue();
                String type = ObjectHelper.classCanonicalName(value);
                sb.append((CharSequence)prefix);
                sb.append("    <header key=\"").append((String)entry.getKey()).append("\"");
                if (type != null) {
                    sb.append(" type=\"").append(type).append("\"");
                }
                sb.append(">");
                if (value != null) {
                    try {
                        String xml = (String)message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), value);
                        if (xml != null) {
                            sb.append(StringHelper.xmlEncode((String)xml));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sb.append("</header>\n");
            }
            sb.append((CharSequence)prefix);
            sb.append("  </headers>\n");
        }
        if (includeBody) {
            long pos;
            sb.append((CharSequence)prefix);
            sb.append("  <body");
            Object body = message.getBody();
            String type = ObjectHelper.classCanonicalName((Object)body);
            if (type != null) {
                sb.append(" type=\"").append(type).append("\"");
            }
            if (body instanceof Collection) {
                long size = ((Collection)body).size();
                sb.append(" size=\"").append(size).append("\"");
            }
            if (body != null && body.getClass().isArray()) {
                int size = Array.getLength(body);
                sb.append(" size=\"").append(size).append("\"");
            }
            if (body instanceof StreamCache && (pos = ((StreamCache)body).position()) != -1L) {
                sb.append(" position=\"").append(pos).append("\"");
            }
            sb.append(">");
            String xml = MessageHelper.extractBodyForLogging(message, null, allowCachedStreams, allowStreams, allowFiles, maxChars);
            if (xml != null) {
                sb.append(StringHelper.xmlEncode((String)xml));
            }
            sb.append("</body>\n");
        }
        sb.append((CharSequence)prefix);
        sb.append("</message>");
        return sb.toString();
    }

    public static void copyBody(Message source, Message target) {
        if (source.hasTrait(MessageTrait.DATA_AWARE)) {
            target.setBody(source.getBody());
            target.setPayloadForTrait(MessageTrait.DATA_AWARE, source.getPayloadForTrait(MessageTrait.DATA_AWARE));
            return;
        }
        target.setBody(source.getBody());
    }

    public static void copyHeaders(Message source, Message target, boolean override) {
        MessageHelper.copyHeaders(source, target, null, override);
    }

    public static void copyHeaders(Message source, Message target, HeaderFilterStrategy strategy, boolean override) {
        if (!source.hasHeaders()) {
            return;
        }
        for (Map.Entry entry : source.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (target.getHeader(key) != null && !override) continue;
            if (strategy == null) {
                target.setHeader(key, value);
                continue;
            }
            if (strategy.applyFilterToExternalHeaders(key, value, target.getExchange())) continue;
            target.setHeader(key, value);
        }
    }

    public static String dumpMessageHistoryStacktrace(Exchange exchange, ExchangeFormatter exchangeFormatter, boolean logStackTrace) {
        try {
            return MessageHelper.doDumpMessageHistoryStacktrace(exchange, exchangeFormatter, logStackTrace);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String doDumpMessageHistoryStacktrace(Exchange exchange, ExchangeFormatter exchangeFormatter, boolean logStackTrace) {
        String loc;
        String routeId = exchange.getFromRouteId();
        Route route = exchange.getContext().getRoute(routeId);
        String string = loc = route != null ? route.getSourceLocationShort() : null;
        if (loc == null) {
            loc = "";
        }
        String id = routeId;
        Object label = "";
        if (exchange.getFromEndpoint() != null) {
            label = "from[" + URISupport.sanitizeUri((String)StringHelper.limitLength((String)exchange.getFromEndpoint().getEndpointUri(), (int)100)) + "]";
        }
        long elapsed = exchange.getClock().elapsed();
        List list = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
        boolean enabled = list != null;
        boolean source = !loc.isEmpty();
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Message History");
        if (!source && !enabled) {
            sb.append(" (source location and message history is disabled)");
        } else if (!source) {
            sb.append(" (source location is disabled)");
        } else if (!enabled) {
            sb.append(" (complete message history is disabled)");
        }
        sb.append("\n");
        sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
        String goMessageHistoryHeader = exchange.getContext().getGlobalOption("CamelMessageHistoryHeaderFormat");
        sb.append(String.format(goMessageHistoryHeader == null ? MESSAGE_HISTORY_HEADER : goMessageHistoryHeader, "Source", "ID", "Processor", "Elapsed (ms)"));
        sb.append("\n");
        String goMessageHistoryOutput = exchange.getContext().getGlobalOption("CamelMessageHistoryOutputFormat");
        goMessageHistoryOutput = goMessageHistoryOutput == null ? MESSAGE_HISTORY_OUTPUT : goMessageHistoryOutput;
        sb.append(String.format(goMessageHistoryOutput, loc, routeId + "/" + id, label, elapsed));
        sb.append("\n");
        if (list == null || list.isEmpty()) {
            id = exchange.getExchangeExtension().getHistoryNodeId();
            if (id != null) {
                String rid;
                loc = exchange.getExchangeExtension().getHistoryNodeSource();
                if (loc == null) {
                    loc = "";
                }
                if ((rid = ExchangeHelper.getAtRouteId(exchange)) != null) {
                    routeId = rid;
                }
                label = exchange.getExchangeExtension().getHistoryNodeLabel();
                label = URISupport.sanitizeUri((String)StringHelper.limitLength((String)label, (int)100));
                sb.append("\t...\n");
                sb.append(String.format(goMessageHistoryOutput, loc, routeId + "/" + id, label, 0));
                sb.append("\n");
            }
        } else {
            for (MessageHistory history : list) {
                loc = LoggerHelper.getLineNumberLoggerName(history.getNode());
                if (loc == null) {
                    loc = "";
                }
                routeId = history.getRouteId() != null ? history.getRouteId() : "";
                id = history.getNode().getId();
                label = URISupport.sanitizeUri((String)StringHelper.limitLength((String)history.getNode().getLabel(), (int)100));
                sb.append(String.format(goMessageHistoryOutput, loc, routeId + "/" + id, label, history.getElapsed()));
                sb.append("\n");
            }
        }
        if (exchangeFormatter != null) {
            sb.append("\nExchange\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append(exchangeFormatter.format(exchange));
            sb.append("\n");
        }
        if (logStackTrace) {
            sb.append("\nStacktrace\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------");
        }
        return sb.toString();
    }

    public static String dumpAsJSon(Message message) {
        return MessageHelper.dumpAsJSon(message, true);
    }

    public static String dumpAsJSon(Message message, boolean includeBody) {
        return MessageHelper.dumpAsJSon(message, includeBody, 0);
    }

    public static String dumpAsJSon(Message message, boolean includeBody, int indent) {
        return MessageHelper.dumpAsJSon(message, includeBody, indent, false, true, 131072, true);
    }

    public static String dumpAsJSon(Message message, boolean includeBody, int indent, boolean allowStreams, boolean allowFiles, int maxChars, boolean pretty) {
        return MessageHelper.dumpAsJSon(message, false, includeBody, indent, false, allowStreams, allowFiles, maxChars, pretty);
    }

    public static String dumpAsJSon(Message message, boolean includeExchangeProperties, boolean includeBody, int indent, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars, boolean pretty) {
        JsonObject jo = MessageHelper.dumpAsJSonObject(message, includeExchangeProperties, includeBody, allowCachedStreams, allowStreams, allowFiles, maxChars);
        String answer = jo.toJson();
        if (pretty) {
            answer = indent > 0 ? Jsoner.prettyPrint((String)answer, (int)indent) : Jsoner.prettyPrint((String)answer);
        }
        return answer;
    }

    public static JsonObject dumpAsJSonObject(Message message, boolean includeExchangeProperties, boolean includeBody, boolean allowCachedStreams, boolean allowStreams, boolean allowFiles, int maxChars) {
        JsonObject jh;
        String type;
        Object value;
        JsonArray arr;
        JsonObject root = new JsonObject();
        JsonObject jo = new JsonObject();
        root.put((Object)"message", (Object)jo);
        jo.put((Object)"exchangeId", (Object)message.getExchange().getExchangeId());
        jo.put((Object)"exchangePattern", (Object)message.getExchange().getPattern().name());
        jo.put((Object)"exchangeType", (Object)ObjectHelper.classCanonicalName((Object)message.getExchange()));
        jo.put((Object)"messageType", (Object)ObjectHelper.classCanonicalName((Object)message));
        if (includeExchangeProperties && message.getExchange().hasProperties()) {
            arr = new JsonArray();
            TreeMap properties = new TreeMap(message.getExchange().getAllProperties());
            for (Map.Entry entry : properties.entrySet()) {
                value = entry.getValue();
                type = ObjectHelper.classCanonicalName(value);
                jh = new JsonObject();
                String key = (String)entry.getKey();
                if ("CamelMessageHistory".equals(key)) continue;
                jh.put((Object)"key", (Object)key);
                if (type != null) {
                    jh.put((Object)"type", (Object)type);
                }
                if (value != null) {
                    Object s = Jsoner.trySerialize(value);
                    if (s == null) {
                        try {
                            s = message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), value);
                        }
                        catch (Exception exception) {}
                    } else {
                        s = value;
                    }
                    jh.put((Object)"value", s);
                }
                arr.add((Object)jh);
            }
            if (!arr.isEmpty()) {
                jo.put((Object)"exchangeProperties", (Object)arr);
            }
        }
        if (message.hasHeaders()) {
            arr = new JsonArray();
            TreeMap headers = new TreeMap(message.getHeaders());
            for (Map.Entry entry : headers.entrySet()) {
                value = entry.getValue();
                type = ObjectHelper.classCanonicalName(value);
                jh = new JsonObject();
                jh.put((Object)"key", entry.getKey());
                if (type != null) {
                    jh.put((Object)"type", (Object)type);
                }
                if (value != null) {
                    Object s = Jsoner.trySerialize(value);
                    if (s == null) {
                        try {
                            s = message.getExchange().getContext().getTypeConverter().tryConvertTo(String.class, message.getExchange(), value);
                        }
                        catch (Exception exception) {}
                    } else {
                        s = value;
                    }
                    jh.put((Object)"value", s);
                }
                arr.add((Object)jh);
            }
            if (!arr.isEmpty()) {
                jo.put((Object)"headers", (Object)arr);
            }
        }
        if (includeBody) {
            String data;
            long pos;
            JsonObject jb = new JsonObject();
            jo.put((Object)"body", (Object)jb);
            Object body = message.getBody();
            String type2 = ObjectHelper.classCanonicalName((Object)body);
            if (type2 != null) {
                jb.put((Object)"type", (Object)type2);
            }
            if (body instanceof Collection) {
                long size = ((Collection)body).size();
                jb.put((Object)"size", (Object)size);
            }
            if (body != null && body.getClass().isArray()) {
                int size = Array.getLength(body);
                jb.put((Object)"size", (Object)size);
            }
            if (body instanceof StreamCache && (pos = ((StreamCache)body).position()) != -1L) {
                jb.put((Object)"position", (Object)pos);
            }
            if ((data = MessageHelper.extractBodyForLogging(message, null, allowCachedStreams, allowStreams, allowFiles, maxChars)) != null) {
                jb.put((Object)"value", (Object)Jsoner.escape((String)data));
            }
        }
        return root;
    }

    public static String dumpExceptionAsXML(Throwable exception, int indent) {
        StringBuilder prefix = new StringBuilder();
        prefix.append(" ".repeat(indent));
        StringBuilder sb = new StringBuilder();
        try {
            String msg;
            sb.append((CharSequence)prefix).append("<exception");
            String type = ObjectHelper.classCanonicalName((Object)exception);
            if (type != null) {
                sb.append(" type=\"").append(type).append("\"");
            }
            if ((msg = exception.getMessage()) != null) {
                msg = StringHelper.xmlEncode((String)msg);
                sb.append(" message=\"").append(msg).append("\"");
            }
            sb.append(">\n");
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            String trace = sw.toString();
            sb.append(StringHelper.xmlEncode((String)trace));
            sb.append((CharSequence)prefix).append("</exception>");
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String dumpExceptionAsJSon(Throwable exception, int indent, boolean pretty) {
        JsonObject jo = MessageHelper.dumpExceptionAsJSonObject(exception);
        String answer = jo.toJson();
        if (pretty) {
            answer = indent > 0 ? Jsoner.prettyPrint((String)answer, (int)indent) : Jsoner.prettyPrint((String)answer);
        }
        return answer;
    }

    public static JsonObject dumpExceptionAsJSonObject(Throwable exception) {
        JsonObject root = new JsonObject();
        JsonObject jo = new JsonObject();
        root.put((Object)"exception", (Object)jo);
        String type = ObjectHelper.classCanonicalName((Object)exception);
        if (type != null) {
            jo.put((Object)"type", (Object)type);
        }
        String msg = exception.getMessage();
        jo.put((Object)"message", (Object)msg);
        StringWriter sw = new StringWriter();
        exception.printStackTrace(new PrintWriter(sw));
        String trace = sw.toString();
        try {
            jo.put((Object)"stackTrace", (Object)Jsoner.escape((String)trace));
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return root;
    }
}

