/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Traceable;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class UnmarshalProcessor
extends AsyncProcessorSupport
implements Traceable,
CamelContextAware,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private final DataFormat dataFormat;
    private final boolean allowNullBody;

    public UnmarshalProcessor(DataFormat dataFormat) {
        this(dataFormat, false);
    }

    public UnmarshalProcessor(DataFormat dataFormat, boolean allowNullBody) {
        this.dataFormat = dataFormat;
        this.allowNullBody = allowNullBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        block12: {
            ObjectHelper.notNull((Object)this.dataFormat, (String)"dataFormat");
            stream = null;
            result = null;
            try {
                in = exchange.getIn();
                if (this.allowNullBody && in.getBody() == null) {
                    out = exchange.getOut();
                } else {
                    stream = (InputStream)in.getMandatoryBody(InputStream.class);
                    out = exchange.getOut();
                    out.copyFrom(in);
                    result = this.dataFormat.unmarshal(exchange, stream);
                }
                if (result instanceof Exchange) {
                    if (result != exchange) {
                        throw new RuntimeCamelException("The returned exchange " + result + " is not the same as " + exchange + " provided to the DataFormat");
                    }
                    break block12;
                }
                if (result instanceof Message) {
                    exchange.setOut((Message)result);
                    break block12;
                }
                out.setBody(result);
            }
            catch (Throwable e) {
                try {
                    exchange.setOut(null);
                    exchange.setException(e);
                }
                catch (Throwable var7_8) {
                    if (!(result instanceof Iterator)) {
                        IOHelper.close(stream, (String)"input stream");
                    }
                    throw var7_8;
                }
                if (!(result instanceof Iterator)) {
                    IOHelper.close((Closeable)stream, (String)"input stream");
                } else {
                    ** GOTO lbl37
                }
            }
        }
        if (!(result instanceof Iterator)) {
            IOHelper.close((Closeable)stream, (String)"input stream");
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Unmarshal[" + this.dataFormat + "]";
    }

    public String getTraceLabel() {
        return "unmarshal[" + this.dataFormat + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected void doStart() throws Exception {
        CamelContextAware.trySetCamelContext((Object)this.dataFormat, (CamelContext)this.camelContext);
        this.getCamelContext().addService((Object)this.dataFormat, false, true);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.dataFormat);
        this.getCamelContext().removeService((Object)this.dataFormat);
    }
}

