/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stub;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.stub.StubEndpoint;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="stub", description="Browse messages on stub endpoints")
public class StubConsole
extends AbstractDevConsole {
    public static final String FILTER = "filter";
    public static final String LIMIT = "limit";
    public static final String FORMAT = "format";
    public static final String BROWSE = "browse";

    public StubConsole() {
        super("camel", "stub", "Stub", "Browse messages on stub endpoints");
    }

    protected String doCallText(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        String browse = (String)options.get(BROWSE);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        boolean dump = browse == null ? Boolean.FALSE : Boolean.parseBoolean(browse);
        StringBuilder sb = new StringBuilder();
        List<StubEndpoint> list = this.getCamelContext().getEndpoints().stream().filter(e -> e instanceof StubEndpoint).map(StubEndpoint.class::cast).filter(e -> StubConsole.accept(e.getName(), filter)).toList();
        HashSet<String> names = new HashSet<String>();
        for (StubEndpoint se : list) {
            String name = se.getName();
            if (names.contains(name)) continue;
            names.add(name);
            sb.append(String.format("Queue: %s (max: %d, size: %d)%n", name, se.getSize(), se.getCurrentQueueSize()));
            if (!dump) continue;
            BlockingQueue q = se.getQueue();
            List copy = new ArrayList(q);
            if (max > 0 && q.size() > max) {
                int pos = q.size() - 1 - max;
                int end = q.size() - 1;
                copy = copy.subList(pos, end);
            }
            for (Exchange exchange : copy) {
                try {
                    String format = (String)options.get(FORMAT);
                    String msg = null;
                    if (format == null || "xml".equals(format)) {
                        msg = MessageHelper.dumpAsXml((Message)exchange.getMessage(), (boolean)true, (int)4);
                    } else if ("json".equals(format)) {
                        msg = MessageHelper.dumpAsJSon((Message)exchange.getMessage(), (boolean)true, (int)4);
                    }
                    if (msg == null) continue;
                    sb.append("\n").append(msg).append("\n");
                }
                catch (Exception exception) {}
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        String filter = (String)options.get(FILTER);
        String limit = (String)options.get(LIMIT);
        String browse = (String)options.get(BROWSE);
        int max = limit == null ? Integer.MAX_VALUE : Integer.parseInt(limit);
        boolean dump = browse == null ? Boolean.FALSE : Boolean.parseBoolean(browse);
        JsonObject root = new JsonObject();
        JsonArray queues = new JsonArray();
        List<StubEndpoint> list = this.getCamelContext().getEndpoints().stream().filter(e -> e instanceof StubEndpoint).map(StubEndpoint.class::cast).filter(e -> StubConsole.accept(e.getName(), filter)).toList();
        HashSet<String> names = new HashSet<String>();
        for (StubEndpoint se : list) {
            String name = se.getName();
            if (names.contains(name)) continue;
            names.add(name);
            JsonObject jo = new JsonObject();
            jo.put((Object)"name", (Object)name);
            jo.put((Object)"endpointUri", (Object)se.getEndpointUri());
            jo.put((Object)"max", (Object)se.getSize());
            jo.put((Object)"size", (Object)se.getCurrentQueueSize());
            if (dump) {
                ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
                BlockingQueue q = se.getQueue();
                List copy = new ArrayList(q);
                if (max > 0 && q.size() > max) {
                    int pos = q.size() - 1 - max;
                    int end = q.size() - 1;
                    copy = copy.subList(pos, end);
                }
                for (Exchange exchange : copy) {
                    try {
                        JsonObject msg = MessageHelper.dumpAsJSonObject((Message)exchange.getMessage(), (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (int)131072);
                        arr.add(msg);
                    }
                    catch (Exception exception) {}
                }
                if (!arr.isEmpty()) {
                    jo.put((Object)"messages", arr);
                }
            }
            queues.add((Object)jo);
        }
        root.put((Object)"queues", (Object)queues);
        return root;
    }

    private static boolean accept(String name, String filter) {
        if (filter == null || filter.isBlank()) {
            return true;
        }
        return PatternHelper.matchPattern((String)name, (String)filter);
    }
}

