/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class StreamEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":kind";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "stream".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "kind", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(24);
        props.add("appendNewLine");
        props.add("autoCloseCount");
        props.add("bridgeErrorHandler");
        props.add("closeOnDone");
        props.add("delay");
        props.add("encoding");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("fileName");
        props.add("fileWatcher");
        props.add("groupLines");
        props.add("groupStrategy");
        props.add("httpHeaders");
        props.add("httpUrl");
        props.add("initialPromptDelay");
        props.add("kind");
        props.add("lazyStartProducer");
        props.add("promptDelay");
        props.add("promptMessage");
        props.add("readLine");
        props.add("readTimeout");
        props.add("retry");
        props.add("scanStream");
        props.add("scanStreamDelay");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

