/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.stomp.StompConfiguration;
import org.apache.camel.component.stomp.StompEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.support.HeaderFilterStrategyComponent;

@Component(value="stomp")
public class StompComponent
extends HeaderFilterStrategyComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private StompConfiguration configuration = new StompConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    protected void doInit() throws Exception {
        super.doInit();
        if (this.getHeaderFilterStrategy() == null) {
            this.setHeaderFilterStrategy((HeaderFilterStrategy)new DefaultHeaderFilterStrategy());
        }
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        StompConfiguration config = this.getConfiguration().copy();
        StompEndpoint endpoint = new StompEndpoint(uri, this, config, remaining);
        endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        this.setProperties((Endpoint)endpoint, parameters);
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    public StompConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(StompConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

