/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import com.ctc.wstx.sr.ValidatingStreamReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.stax.StaxStreamXMLReader;
import org.apache.camel.support.ExchangeHelper;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class StAXProcessor
implements Processor {
    private final Class<ContentHandler> contentHandlerClass;
    private final ContentHandler contentHandler;

    public StAXProcessor(Class<ContentHandler> contentHandlerClass) {
        this.contentHandlerClass = contentHandlerClass;
        this.contentHandler = null;
    }

    public StAXProcessor(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.contentHandlerClass = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        XMLStreamReader stream = null;
        try {
            stream = (XMLStreamReader)exchange.getIn().getMandatoryBody(XMLStreamReader.class);
            StaxStreamXMLReader reader = new StaxStreamXMLReader(stream);
            ContentHandler handler = this.contentHandlerClass != null ? this.contentHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : this.contentHandler;
            reader.setContentHandler(handler);
            reader.parse((InputSource)null);
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                exchange.getOut().setHeaders(exchange.getIn().getHeaders());
                exchange.getOut().setBody((Object)handler);
            } else {
                exchange.getIn().setBody((Object)handler);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
                if (stream instanceof ValidatingStreamReader) {
                    ((ValidatingStreamReader)stream).closeCompletely();
                }
            }
        }
    }
}

