/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.stax.StAXUtil;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class StAXJAXBIteratorExpression<T>
extends ExpressionAdapter {
    private static final Map<Class<?>, JAXBContext> JAX_CONTEXTS = LRUCacheFactory.newLRUSoftCache((int)1000);
    private final Class<T> handled;
    private final String handledName;
    private final boolean isNamespaceAware;

    public StAXJAXBIteratorExpression(Class<T> handled) {
        this(handled, true);
    }

    public StAXJAXBIteratorExpression(Class<T> handled, boolean isNamespaceAware) {
        ObjectHelper.notNull(handled, (String)"handled");
        this.handled = handled;
        this.handledName = null;
        this.isNamespaceAware = isNamespaceAware;
    }

    public StAXJAXBIteratorExpression(String handledName) {
        this(handledName, true);
    }

    public StAXJAXBIteratorExpression(String handledName, boolean isNamespaceAware) {
        ObjectHelper.notNull((Object)handledName, (String)"handledName");
        this.handled = null;
        this.handledName = handledName;
        this.isNamespaceAware = isNamespaceAware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext jaxbContext(Class<?> handled) throws JAXBException {
        JAXBContext context;
        if (JAX_CONTEXTS.containsKey(handled)) {
            return JAX_CONTEXTS.get(handled);
        }
        Map<Class<?>, JAXBContext> map = JAX_CONTEXTS;
        synchronized (map) {
            context = JAXBContext.newInstance((Class[])new Class[]{handled});
            JAX_CONTEXTS.put(handled, context);
        }
        return context;
    }

    public Object evaluate(Exchange exchange) {
        try {
            Class clazz;
            InputStream inputStream = null;
            XMLEventReader reader = (XMLEventReader)exchange.getContext().getTypeConverter().tryConvertTo(XMLEventReader.class, exchange, exchange.getIn().getBody());
            if (reader == null) {
                inputStream = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", this.isNamespaceAware);
                xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                reader = xmlInputFactory.createXMLEventReader(inputStream);
            }
            if ((clazz = this.handled) == null && this.handledName != null) {
                clazz = exchange.getContext().getClassResolver().resolveMandatoryClass(this.handledName);
            }
            return this.createIterator(reader, clazz, inputStream);
        }
        catch (InvalidPayloadException e) {
            exchange.setException((Throwable)e);
            return null;
        }
        catch (JAXBException e) {
            exchange.setException((Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            exchange.setException((Throwable)e);
            return null;
        }
        catch (XMLStreamException e) {
            exchange.setException((Throwable)e);
            return null;
        }
    }

    private Iterator<T> createIterator(XMLEventReader reader, Class<T> clazz, InputStream inputStream) throws JAXBException {
        return new StAXJAXBIterator<T>(clazz, reader, inputStream);
    }

    static class StAXJAXBIterator<T>
    implements Iterator<T>,
    Closeable {
        private final XMLEventReader reader;
        private final InputStream inputStream;
        private final Class<T> clazz;
        private final String name;
        private final Unmarshaller unmarshaller;
        private T element;

        StAXJAXBIterator(Class<T> clazz, XMLEventReader reader, InputStream inputStream) throws JAXBException {
            this.clazz = clazz;
            this.reader = reader;
            this.inputStream = inputStream;
            this.name = StAXUtil.getTagName(clazz);
            JAXBContext jaxb = StAXJAXBIteratorExpression.jaxbContext(clazz);
            this.unmarshaller = jaxb.createUnmarshaller();
        }

        @Override
        public boolean hasNext() {
            if (this.element == null) {
                this.element = this.getNextElement();
            }
            return this.element != null;
        }

        @Override
        public T next() {
            if (this.element == null) {
                this.element = this.getNextElement();
            }
            T answer = this.element;
            this.element = null;
            return answer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        T getNextElement() {
            boolean found = false;
            while (!found && this.reader.hasNext()) {
                try {
                    XMLEvent xmlEvent = this.reader.peek();
                    if (xmlEvent != null && xmlEvent.isStartElement() && this.name.equals(xmlEvent.asStartElement().getName().getLocalPart())) {
                        found = true;
                        continue;
                    }
                    this.reader.nextEvent();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
            }
            if (!found) {
                return null;
            }
            try {
                return (T)this.unmarshaller.unmarshal(this.reader, this.clazz).getValue();
            }
            catch (JAXBException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                IOHelper.close((Closeable)this.inputStream);
            }
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
    }
}

