/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stax;

import org.apache.camel.CamelContext;
import org.apache.camel.component.stax.StAXProcessor;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.EndpointHelper;
import org.xml.sax.ContentHandler;

@UriEndpoint(firstVersion="2.9.0", scheme="stax", title="StAX", syntax="stax:contentHandlerClass", producerOnly=true, label="transformation")
public class StAXEndpoint
extends ProcessorEndpoint {
    @UriPath
    @Metadata(required="true")
    private String contentHandlerClass;

    public StAXEndpoint(String endpointUri, CamelContext context) {
        super(endpointUri, context, null);
    }

    public String getContentHandlerClass() {
        return this.contentHandlerClass;
    }

    public void setContentHandlerClass(String contentHandlerClass) {
        this.contentHandlerClass = contentHandlerClass;
    }

    protected void doStart() throws Exception {
        StAXProcessor target;
        super.doStart();
        if (EndpointHelper.isReferenceParameter((String)this.contentHandlerClass)) {
            ContentHandler handler = (ContentHandler)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)this.contentHandlerClass.substring(1), ContentHandler.class, (boolean)true);
            target = new StAXProcessor(handler);
        } else {
            Class clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(this.contentHandlerClass, ContentHandler.class);
            target = new StAXProcessor(clazz);
        }
        this.setProcessor(target);
    }
}

