/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.ssh.ResourceHelperKeyPairProvider;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.component.ssh.SshResult;
import org.apache.camel.component.ssh.SshShellOutputStringHelper;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.session.SessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(SshHelper.class);

    private SshHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshResult sendExecCommand(Map<String, Object> headers, String command, SshEndpoint endpoint, SshClient client) throws Exception {
        SshConfiguration configuration = endpoint.getConfiguration();
        if (configuration == null) {
            throw new IllegalStateException("Configuration must be set");
        }
        String userName = configuration.getUsername();
        Object userNameHeaderObj = headers.get("CamelSshUsername");
        if (userNameHeaderObj instanceof String) {
            userName = (String)headers.get("CamelSshUsername");
        }
        ConnectFuture connectFuture = client.connect(userName, configuration.getHost(), configuration.getPort());
        connectFuture.await(configuration.getTimeout());
        if (!connectFuture.isDone() || !connectFuture.isConnected()) {
            throw new RuntimeCamelException("Failed to connect to " + configuration.getHost() + ":" + configuration.getPort() + " within timeout " + configuration.getTimeout() + "ms");
        }
        LOG.debug("Connected to {}:{}", (Object)configuration.getHost(), (Object)configuration.getPort());
        ClientChannel channel = null;
        ClientSession session = null;
        try {
            Object keyPairProvider;
            session = (ClientSession)connectFuture.getSession();
            String certResource = configuration.getCertResource();
            if (certResource != null) {
                LOG.debug("Attempting to authenticate using ResourceKey '{}'...", (Object)certResource);
                if (endpoint.getCertResourcePassword() != null) {
                    Supplier<char[]> passwordFinder = () -> endpoint.getCertResourcePassword().toCharArray();
                    keyPairProvider = new ResourceHelperKeyPairProvider(new String[]{certResource}, passwordFinder, endpoint.getCamelContext());
                } else {
                    keyPairProvider = new ResourceHelperKeyPairProvider(new String[]{certResource}, endpoint.getCamelContext());
                }
            } else {
                keyPairProvider = configuration.getKeyPairProvider();
            }
            if (keyPairProvider != null) {
                LOG.debug("Attempting to authenticate username '{}' using a key identity", (Object)userName);
                KeyPair pair = null;
                if (configuration.getKeyType() == null) {
                    Iterator iterator = keyPairProvider.loadKeys((SessionContext)session).iterator();
                    if (iterator.hasNext()) {
                        pair = (KeyPair)iterator.next();
                    }
                } else {
                    pair = keyPairProvider.loadKey((SessionContext)session, configuration.getKeyType());
                }
                session.addPublicKeyIdentity(pair);
            } else {
                String password = configuration.getPassword();
                Object passwordHeaderObj = headers.get("CamelSshPassword");
                if (passwordHeaderObj instanceof String) {
                    password = (String)headers.get("CamelSshPassword");
                }
                LOG.debug("Attempting to authenticate username '{}' using a password identity", (Object)userName);
                session.addPasswordIdentity(password);
            }
            AuthFuture authResult = session.auth();
            authResult.await(configuration.getTimeout());
            if (!authResult.isDone() || authResult.isFailure()) {
                LOG.debug("Failed to authenticate");
                throw new RuntimeCamelException("Failed to authenticate username " + configuration.getUsername());
            }
            InputStream in = null;
            PipedOutputStream reply = new PipedOutputStream();
            if ("exec".equals(endpoint.getChannelType())) {
                channel = session.createChannel("exec", command);
                in = new ByteArrayInputStream(new byte[]{0});
            } else if ("shell".equals(endpoint.getChannelType())) {
                channel = session.createChannel("shell");
                in = new PipedInputStream(reply);
            }
            channel.setIn(in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            channel.setOut((OutputStream)out);
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            channel.setErr((OutputStream)err);
            OpenFuture openFuture = channel.open();
            openFuture.await(configuration.getTimeout());
            SshResult result = null;
            if ("exec".equals(endpoint.getChannelType())) {
                Set events;
                if (openFuture.isOpened() && !(events = channel.waitFor(Arrays.asList(ClientChannelEvent.CLOSED), 0L)).contains(ClientChannelEvent.TIMEOUT)) {
                    result = new SshResult(command, channel.getExitStatus(), new ByteArrayInputStream(out.toByteArray()), new ByteArrayInputStream(err.toByteArray()));
                }
            } else if ("shell".equals(endpoint.getChannelType())) {
                SshHelper.getPrompt(channel, out, endpoint);
                reply.write(command.getBytes());
                reply.write(System.lineSeparator().getBytes());
                String response = SshHelper.getPrompt(channel, out, endpoint);
                result = new SshResult(command, channel.getExitStatus(), new ByteArrayInputStream(response.getBytes()), new ByteArrayInputStream(err.toByteArray()));
            }
            SshResult sshResult = result;
            return sshResult;
        }
        finally {
            if (channel != null) {
                channel.close(true);
            }
            if (session != null) {
                session.close(false);
            }
        }
    }

    private static String getPrompt(ClientChannel channel, ByteArrayOutputStream output, SshEndpoint endpoint) throws InterruptedException {
        while (!channel.isClosed()) {
            String response = output.toString(StandardCharsets.UTF_8);
            if (response.trim().endsWith(endpoint.getShellPrompt())) {
                output.reset();
                return SshShellOutputStringHelper.betweenBeforeLast(response, System.lineSeparator(), System.lineSeparator());
            }
            Thread.sleep(endpoint.getSleepForShellPrompt());
        }
        return null;
    }
}

