/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.jdbc;

import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.jdbc.JdbcAggregationRepository;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.PlatformTransactionManager;

public class PostgresAggregationRepository
extends JdbcAggregationRepository {
    public PostgresAggregationRepository() {
    }

    public PostgresAggregationRepository(PlatformTransactionManager transactionManager, String repositoryName, DataSource dataSource) {
        super(transactionManager, repositoryName, dataSource);
    }

    @Override
    protected void insert(CamelContext camelContext, String correlationId, Exchange exchange, String repositoryName, Long version) throws Exception {
        int totalParameterIndex = 2;
        StringBuilder queryBuilder = new StringBuilder(256).append("INSERT INTO ").append(repositoryName).append('(').append("exchange").append(", ").append("id");
        if (this.isStoreBodyAsText()) {
            queryBuilder.append(", ").append("body");
            ++totalParameterIndex;
        }
        if (this.hasHeadersToStoreAsText()) {
            for (String headerName : this.getHeadersToStoreAsText()) {
                queryBuilder.append(", ").append(headerName);
                ++totalParameterIndex;
            }
        }
        queryBuilder.append(") VALUES (");
        queryBuilder.append("?, ".repeat(totalParameterIndex - 1));
        queryBuilder.append("?)");
        queryBuilder.append(" ON CONFLICT DO NOTHING");
        String sql = queryBuilder.toString();
        int updateCount = this.insertHelper(camelContext, correlationId, exchange, sql, 1L);
        if (updateCount == 0 && this.getRepositoryName().equals(repositoryName)) {
            throw new DataIntegrityViolationException("No row was inserted due to data violation");
        }
    }
}

