/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql.stored.template.ast;

import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.component.sql.stored.template.ast.ParseRuntimeException;
import org.apache.camel.component.sql.stored.template.ast.ValueExtractor;
import org.apache.camel.component.sql.stored.template.generated.Token;

public class InOutParameter {
    private final String typeName;
    private final int sqlType;
    private final Integer scale;
    private ValueExtractor valueExtractor;
    private String outValueMapKey;

    public InOutParameter(int sqlType, Token valueSrcToken, Integer scale, String typeName, String outValueMapKey) {
        this.sqlType = sqlType;
        this.parseValueExpression(valueSrcToken);
        this.scale = scale;
        this.typeName = typeName;
        this.outValueMapKey = outValueMapKey;
        if (this.scale != null && this.typeName != null) {
            throw new ParseRuntimeException(String.format("Both scale=%s and typeName=%s cannot be set", this.scale, this.typeName));
        }
    }

    private void parseValueExpression(Token valueSrcToken) {
        if (14 == valueSrcToken.kind) {
            this.valueExtractor = (exchange, container) -> {
                Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(valueSrcToken.toString());
                return exp.evaluate(exchange, Object.class);
            };
        } else if (15 == valueSrcToken.kind) {
            String mapKey = valueSrcToken.toString().substring(2);
            this.valueExtractor = (exchange, container) -> ((Map)container).get(mapKey);
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Integer getScale() {
        return this.scale;
    }

    public ValueExtractor getValueExtractor() {
        return this.valueExtractor;
    }

    public String getOutValueMapKey() {
        return this.outValueMapKey;
    }
}

