/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.event.CamelEvent;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

public class EventEndpoint
extends DefaultEndpoint
implements ApplicationContextAware {
    private LoadBalancer loadBalancer;
    private ApplicationContext applicationContext;

    public EventEndpoint(String endpointUri, EventComponent component) {
        super(endpointUri, (Component)component);
        this.applicationContext = component.getApplicationContext();
    }

    @Deprecated
    public EventEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.applicationContext, (String)"applicationContext");
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                ApplicationEvent event = EventEndpoint.this.toApplicationEvent(exchange);
                EventEndpoint.this.applicationContext.publishEvent(event);
            }
        };
    }

    public EventConsumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.applicationContext, (String)"applicationContext");
        EventConsumer answer = new EventConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody((Object)event);
        try {
            this.getLoadBalancer().process(exchange);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public synchronized void consumerStarted(EventConsumer consumer) {
        this.getLoadBalancer().addProcessor(consumer.getProcessor());
    }

    public synchronized void consumerStopped(EventConsumer consumer) {
        this.getLoadBalancer().removeProcessor(consumer.getProcessor());
    }

    protected LoadBalancer createLoadBalancer() {
        return new TopicLoadBalancer();
    }

    protected ApplicationEvent toApplicationEvent(Exchange exchange) {
        ApplicationEvent event = (ApplicationEvent)exchange.getIn().getBody(ApplicationEvent.class);
        if (event != null) {
            return event;
        }
        return new CamelEvent(this, exchange);
    }
}

