/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws.bean;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.ws.SpringWebserviceConsumer;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping;
import org.apache.camel.component.spring.ws.type.EndpointMappingKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.server.AbstractAddressingEndpointMapping;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WSACamelEndpointMapping
extends AbstractAddressingEndpointMapping
implements CamelSpringWSEndpointMapping {
    private static final Logger LOG = LoggerFactory.getLogger(WSACamelEndpointMapping.class);
    private Map<EndpointMappingKey, MessageEndpoint> endpoints = new ConcurrentHashMap<EndpointMappingKey, MessageEndpoint>();
    private String outputActionSuffix = "Response";
    private String faultActionSuffix = "Response";

    protected Object getEndpointInternal(MessageAddressingProperties map) {
        EndpointMappingKey key;
        for (Map.Entry<EndpointMappingKey, MessageEndpoint> endpointEntry : this.endpoints.entrySet()) {
            key = endpointEntry.getKey();
            String compositeOrSimpleKey = null;
            switch (key.getType()) {
                case ACTION: {
                    compositeOrSimpleKey = this.getActionCompositeLookupKey(map);
                    break;
                }
                case TO: {
                    compositeOrSimpleKey = this.getToCompositeLookupKey(map);
                    break;
                }
                default: {
                    throw new RuntimeCamelException("Invalid mapping type specified. Supported types are: spring-ws:action:<WS-Addressing Action>(optional:<WS-Addressing To>?<params...>\n)spring-ws:to:<WS-Addressing To>(optional:<WS-Addressing Action>?<params...>)");
                }
            }
            if (compositeOrSimpleKey == null || !key.getLookupKey().equals(compositeOrSimpleKey)) continue;
            LOG.debug("Found mapping for key {}", (Object)key);
            return endpointEntry.getValue();
        }
        for (Map.Entry<EndpointMappingKey, MessageEndpoint> endpointEntry : this.endpoints.entrySet()) {
            key = endpointEntry.getKey();
            String simpleKey = null;
            switch (key.getType()) {
                case ACTION: {
                    if (map.getAction() == null) break;
                    simpleKey = map.getAction().toString();
                    break;
                }
                case TO: {
                    if (map.getTo() == null) break;
                    simpleKey = map.getTo().toString();
                    break;
                }
                default: {
                    throw new RuntimeCamelException("Invalid mapping type specified. Supported types are: spring-ws:action:<WS-Addressing Action>(optional:<WS-Addressing To>?<params...>\n)spring-ws:to:<WS-Addressing To>(optional:<WS-Addressing Action>?<params...>)");
                }
            }
            if (simpleKey == null || !key.getLookupKey().equals(simpleKey)) continue;
            LOG.debug("Found mapping for key {}", (Object)key);
            return endpointEntry.getValue();
        }
        return null;
    }

    protected String getActionCompositeLookupKey(MessageAddressingProperties map) {
        Object key = "";
        if (map.getAction() != null) {
            key = map.getAction().toString();
        }
        if (map.getTo() != null) {
            if (!((String)key).isEmpty()) {
                key = (String)key + ":";
            }
            key = (String)key + map.getTo().toString();
        }
        return key;
    }

    protected String getToCompositeLookupKey(MessageAddressingProperties map) {
        Object key = "";
        if (map.getTo() != null) {
            key = map.getTo().toString();
        }
        if (map.getAction() != null) {
            if (!((String)key).isEmpty()) {
                key = (String)key + ":";
            }
            key = (String)key + map.getAction().toString();
        }
        return key;
    }

    protected URI getResponseAction(Object endpoint, MessageAddressingProperties requestMap) {
        SpringWebserviceEndpoint camelEndpoint = this.getSpringWebserviceEndpoint(endpoint);
        URI actionUri = camelEndpoint.getConfiguration().getOutputAction();
        if (actionUri == null) {
            actionUri = this.getDefaultResponseAction((Object)camelEndpoint, requestMap);
        }
        return actionUri;
    }

    protected WebServiceMessageSender[] getMessageSenders(Object endpoint) {
        SpringWebserviceEndpoint camelEndpoint = this.getSpringWebserviceEndpoint(endpoint);
        if (camelEndpoint.getConfiguration().getMessageSender() != null) {
            return new WebServiceMessageSender[]{camelEndpoint.getConfiguration().getMessageSender()};
        }
        return super.getMessageSenders(endpoint);
    }

    protected MessageIdStrategy getMessageIdStrategy(Object endpoint) {
        SpringWebserviceEndpoint camelEndpoint = this.getSpringWebserviceEndpoint(endpoint);
        if (camelEndpoint.getConfiguration().getMessageIdStrategy() != null) {
            return camelEndpoint.getConfiguration().getMessageIdStrategy();
        }
        return super.getMessageIdStrategy(endpoint);
    }

    protected URI getFaultAction(Object endpoint, MessageAddressingProperties requestMap) {
        SpringWebserviceEndpoint camelEndpoint = this.getSpringWebserviceEndpoint(endpoint);
        URI actionUri = camelEndpoint.getConfiguration().getFaultAction();
        if (actionUri == null) {
            actionUri = this.getDefaultFaultAction((Object)camelEndpoint, requestMap);
        }
        return actionUri;
    }

    private SpringWebserviceEndpoint getSpringWebserviceEndpoint(Object endpoint) {
        Assert.isInstanceOf(SpringWebserviceConsumer.class, (Object)endpoint, (String)"Endpoint needs to be an instance of SpringWebserviceConsumer");
        SpringWebserviceConsumer springWebserviceConsumer = (SpringWebserviceConsumer)((Object)endpoint);
        return (SpringWebserviceEndpoint)springWebserviceConsumer.getEndpoint();
    }

    protected URI getDefaultResponseAction(Object endpoint, MessageAddressingProperties requestMap) {
        URI requestAction = requestMap.getAction();
        if (requestAction != null) {
            return URI.create(requestAction.toString() + this.getOutputActionSuffix());
        }
        return null;
    }

    protected URI getDefaultFaultAction(Object endpoint, MessageAddressingProperties requestMap) {
        URI requestAction = requestMap.getAction();
        if (requestAction != null) {
            return URI.create(requestAction.toString() + this.getFaultActionSuffix());
        }
        return null;
    }

    @Override
    public void addConsumer(EndpointMappingKey key, MessageEndpoint endpoint) {
        this.endpoints.put(key, endpoint);
    }

    @Override
    public void removeConsumer(Object key) {
        this.endpoints.remove(key);
    }

    public String getOutputActionSuffix() {
        return this.outputActionSuffix;
    }

    public void setOutputActionSuffix(String outputActionSuffix) {
        Assert.hasText((String)outputActionSuffix, (String)"'outputActionSuffix' must not be empty");
        this.outputActionSuffix = outputActionSuffix;
    }

    public String getFaultActionSuffix() {
        return this.faultActionSuffix;
    }

    public void setFaultActionSuffix(String faultActionSuffix) {
        Assert.hasText((String)faultActionSuffix, (String)"'faultActionSuffix' must not be empty");
        this.faultActionSuffix = faultActionSuffix;
    }
}

