/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SpringWebserviceEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":type:lookupKey:webServiceEndpointUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "spring-ws".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "type", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "lookupKey", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "webServiceEndpointUri", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(25);
        props.add("allowResponseAttachmentOverride");
        props.add("allowResponseHeaderOverride");
        props.add("bridgeErrorHandler");
        props.add("endpointDispatcher");
        props.add("endpointMapping");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("expression");
        props.add("faultAction");
        props.add("faultTo");
        props.add("lazyStartProducer");
        props.add("lookupKey");
        props.add("messageFactory");
        props.add("messageFilter");
        props.add("messageIdStrategy");
        props.add("messageSender");
        props.add("outputAction");
        props.add("replyTo");
        props.add("soapAction");
        props.add("sslContextParameters");
        props.add("timeout");
        props.add("type");
        props.add("webServiceEndpointUri");
        props.add("webServiceTemplate");
        props.add("wsAddressingAction");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

