/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.springframework.data.redis.core.RedisTemplate;

@Component(value="spring-redis")
public class RedisComponent
extends DefaultComponent {
    @Metadata(autowired=true)
    private RedisTemplate redisTemplate;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RedisConfiguration configuration = new RedisConfiguration();
        configuration.setRedisTemplate(this.redisTemplate);
        this.setHostAndPort(configuration, remaining);
        RedisEndpoint endpoint = new RedisEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    private void setHostAndPort(RedisConfiguration configuration, String remaining) {
        String[] hostAndPort = remaining.split(":");
        if (hostAndPort.length > 0 && hostAndPort[0].length() > 0) {
            configuration.setHost(hostAndPort[0]);
        }
        if (hostAndPort.length > 1 && hostAndPort[1].length() > 0) {
            configuration.setPort(Integer.parseInt(hostAndPort[1]));
        }
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

