/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.MessageHelper;

public class SpringIntegrationMessage
extends DefaultMessage {
    private org.springframework.messaging.Message<?> siMessage;

    public SpringIntegrationMessage(CamelContext camelContext) {
        super(camelContext);
    }

    public SpringIntegrationMessage(Exchange exchange, org.springframework.messaging.Message<?> message) {
        super(exchange);
        this.siMessage = message;
    }

    public SpringIntegrationMessage(CamelContext camelContext, org.springframework.messaging.Message<?> message) {
        super(camelContext);
        this.siMessage = message;
    }

    public void reset() {
        super.reset();
        this.siMessage = null;
    }

    public void setMessage(org.springframework.messaging.Message<?> message) {
        this.siMessage = message;
    }

    public org.springframework.messaging.Message<?> getMessage() {
        return this.siMessage;
    }

    public void copyFrom(Message that) {
        if (that == this) {
            return;
        }
        if (that instanceof CamelContextAware) {
            this.setCamelContext(((CamelContextAware)that).getCamelContext());
        }
        if (this.getExchange() == null) {
            this.setExchange(that.getExchange());
        }
        this.setMessageId(that.getMessageId());
        MessageHelper.copyBody((Message)that, (Message)this);
        super.getHeaders().putAll(that.getHeaders());
        if (that instanceof SpringIntegrationMessage) {
            SpringIntegrationMessage orig = (SpringIntegrationMessage)that;
            this.setMessage(orig.getMessage());
        }
    }

    public String toString() {
        if (this.siMessage != null) {
            return "SpringIntegrationMessage: " + this.siMessage;
        }
        return "SpringIntegrationMessage: " + this.getBody();
    }

    public Object getHeader(String name) {
        if (this.siMessage != null) {
            return this.siMessage.getHeaders().get((Object)name);
        }
        return super.getHeader(name);
    }

    public Map<String, Object> getHeaders() {
        if (this.siMessage != null) {
            return this.siMessage.getHeaders();
        }
        return super.getHeaders();
    }

    public SpringIntegrationMessage newInstance() {
        SpringIntegrationMessage answer = new SpringIntegrationMessage(this.getCamelContext());
        return answer;
    }

    protected Object createBody() {
        return this.siMessage.getPayload();
    }
}

