/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.spring.boot.cloud.CamelCloudAutoConfiguration;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceDiscoveryAutoConfiguration;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.cloud.CamelSpringCloudServiceDiscovery;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.composite.CompositeDiscoveryClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={CamelCloudAutoConfiguration.class, DiscoveryClient.class})
@AutoConfigureAfter(value={CompositeDiscoveryClientAutoConfiguration.class})
@AutoConfigureBefore(value={CamelCloudServiceDiscoveryAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
@Conditional(value={ServiceDiscoveryCondition.class})
public class CamelSpringCloudServiceDiscoveryAutoConfiguration {
    @Bean(name={"spring-cloud-service-discovery"})
    @ConditionalOnMissingBean
    public ServiceDiscovery springCloudServiceDiscovery(DiscoveryClient discoveryClient) {
        return new CamelSpringCloudServiceDiscovery(discoveryClient);
    }

    public static class ServiceDiscoveryCondition
    extends GroupCondition {
        public ServiceDiscoveryCondition() {
            super("camel.cloud", "camel.cloud.service-discovery");
        }
    }
}

