/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud;

import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.cloud.ServiceLoadBalancerFunction;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;

public class DefaultServiceLoadBalancer
implements ServiceLoadBalancer {
    private final LoadBalancerClient client;

    public DefaultServiceLoadBalancer(LoadBalancerClient client) {
        this.client = client;
    }

    public <T> T process(String serviceName, ServiceLoadBalancerFunction<T> function) throws Exception {
        return (T)this.client.execute(serviceName, instance -> function.apply(this.convertServiceInstanceToServiceDefinition(instance)));
    }

    protected ServiceDefinition convertServiceInstanceToServiceDefinition(ServiceInstance instance) {
        return new DefaultServiceDefinition(instance.getServiceId(), instance.getHost(), instance.getPort(), instance.getMetadata());
    }
}

