/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import org.apache.camel.ProducerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

public class CamelJobExecutionListener
implements JobExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(CamelJobExecutionListener.class);
    private final ProducerTemplate producerTemplate;
    private final String endpointUri;

    public CamelJobExecutionListener(ProducerTemplate producerTemplate, String endpointUri) {
        this.producerTemplate = producerTemplate;
        this.endpointUri = endpointUri;
    }

    public void beforeJob(JobExecution jobExecution) {
        LOG.debug("sending before job execution event [{}]...", (Object)jobExecution);
        this.producerTemplate.sendBodyAndHeader(this.endpointUri, (Object)jobExecution, "SPRING_BATCH_JOB_EVENT_TYPE", (Object)EventType.BEFORE.name());
        LOG.debug("sent before job execution event");
    }

    public void afterJob(JobExecution jobExecution) {
        LOG.debug("sending after job execution event [{}]...", (Object)jobExecution);
        this.producerTemplate.sendBodyAndHeader(this.endpointUri, (Object)jobExecution, "SPRING_BATCH_JOB_EVENT_TYPE", (Object)EventType.AFTER.name());
        LOG.debug("sent after job execution event");
    }

    public static enum EventType {
        BEFORE,
        AFTER;

        public static final String HEADER_KEY = "SPRING_BATCH_JOB_EVENT_TYPE";
    }
}

