/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.splunk.ConsumerType;
import org.apache.camel.component.splunk.SplunkEndpoint;
import org.apache.camel.component.splunk.event.SplunkEvent;
import org.apache.camel.component.splunk.support.SplunkDataReader;
import org.apache.camel.component.splunk.support.SplunkResultProcessor;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplunkConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SplunkConsumer.class);
    private SplunkDataReader dataReader;
    private SplunkEndpoint endpoint;

    public SplunkConsumer(SplunkEndpoint endpoint, Processor processor, ConsumerType consumerType) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        if ((consumerType.equals((Object)ConsumerType.NORMAL) || consumerType.equals((Object)ConsumerType.REALTIME)) && ObjectHelper.isEmpty((String)endpoint.getConfiguration().getSearch())) {
            throw new RuntimeException("Missing option 'search' with normal or realtime search");
        }
        if (consumerType.equals((Object)ConsumerType.SAVEDSEARCH) && ObjectHelper.isEmpty((String)endpoint.getConfiguration().getSavedSearch())) {
            throw new RuntimeException("Missing option 'savedSearch' with saved search");
        }
        this.dataReader = new SplunkDataReader(endpoint, consumerType);
    }

    protected int poll() throws Exception {
        try {
            if (this.endpoint.getConfiguration().isStreaming()) {
                this.dataReader.read(new SplunkResultProcessor(){

                    @Override
                    public void process(SplunkEvent splunkEvent) {
                        Exchange exchange = SplunkConsumer.this.createExchange(true);
                        Message message = exchange.getIn();
                        message.setBody((Object)splunkEvent);
                        AsyncCallback cb = SplunkConsumer.this.defaultConsumerCallback(exchange, true);
                        SplunkConsumer.this.getAsyncProcessor().process(exchange, cb);
                    }
                });
                return 0;
            }
            List<SplunkEvent> events = this.dataReader.read();
            Queue<Exchange> exchanges = this.createExchanges(events);
            return this.processBatch(CastUtils.cast(exchanges));
        }
        catch (Exception e) {
            this.endpoint.reset(e);
            this.getExceptionHandler().handleException((Throwable)e);
            return 0;
        }
    }

    protected Queue<Exchange> createExchanges(List<SplunkEvent> splunkEvents) {
        LOG.trace("Received {} messages in this poll", (Object)splunkEvents.size());
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        for (SplunkEvent splunkEvent : splunkEvents) {
            Exchange exchange = this.createExchange(true);
            Message message = exchange.getIn();
            message.setBody((Object)splunkEvent);
            answer.add(exchange);
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            try {
                LOG.trace("Processing exchange [{}]...", (Object)exchange);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() == null) continue;
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
        return total;
    }
}

