/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunkhec;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.splunkhec.SplunkHECComponent;
import org.apache.camel.component.splunkhec.SplunkHECConfiguration;
import org.apache.camel.component.splunkhec.SplunkHECConstants;
import org.apache.camel.component.splunkhec.SplunkHECProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

@UriEndpoint(firstVersion="3.3.0", scheme="splunk-hec", title="Splunk HEC", producerOnly=true, syntax="splunk-hec:splunkURL", category={Category.MONITORING}, headersClass=SplunkHECConstants.class)
public class SplunkHECEndpoint
extends DefaultEndpoint {
    private static final Pattern SPLUNK_URL_PATTERN = Pattern.compile("^(.*?):(\\d+)$");
    private static final Pattern SPLUNK_TOKEN_PATTERN = Pattern.compile("^\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}$");
    @UriPath
    @Metadata(required=true)
    private String splunkURL;
    @UriParam
    private SplunkHECConfiguration configuration;

    public SplunkHECEndpoint() {
    }

    public SplunkHECEndpoint(String uri, SplunkHECComponent component, SplunkHECConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    protected void doInit() throws Exception {
        super.doInit();
        Matcher splunkUrlMatch = SPLUNK_URL_PATTERN.matcher(this.splunkURL);
        if (!splunkUrlMatch.matches()) {
            throw new IllegalArgumentException("Invalid Splunk URL provided");
        }
        String hostname = splunkUrlMatch.group(1);
        int port = Integer.parseInt(splunkUrlMatch.group(2));
        if (!DomainValidator.getInstance((boolean)true).isValid(hostname) && !InetAddressValidator.getInstance().isValidInet4Address(hostname)) {
            throw new IllegalArgumentException("Invalid hostname: " + hostname);
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        String token = this.getConfiguration().getToken();
        if (token == null) {
            throw new IllegalArgumentException("A token must be defined");
        }
        if (!SPLUNK_TOKEN_PATTERN.matcher(token).matches()) {
            throw new IllegalArgumentException("Invalid Splunk HEC token provided");
        }
    }

    public Producer createProducer() {
        return new SplunkHECProducer(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException();
    }

    public SplunkHECConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getSplunkURL() {
        return this.splunkURL;
    }

    public void setSplunkURL(String splunkURL) {
        this.splunkURL = splunkURL;
    }
}

