/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import org.apache.camel.CamelContext;
import org.apache.camel.component.spark.RddCallback;
import org.apache.spark.api.java.JavaRDDLike;

public abstract class ConvertingRddCallback<T>
implements RddCallback<T> {
    private final CamelContext camelContext;
    private final Class[] payloadsTypes;

    public ConvertingRddCallback(CamelContext camelContext, Class ... payloadsTypes) {
        this.camelContext = camelContext;
        this.payloadsTypes = payloadsTypes;
    }

    @Override
    public T onRdd(JavaRDDLike rdd, Object ... payloads) {
        if (payloads.length != this.payloadsTypes.length) {
            String message = String.format("Received %d payloads, but expected %d.", payloads.length, this.payloadsTypes.length);
            throw new IllegalArgumentException(message);
        }
        for (int i = 0; i < payloads.length; ++i) {
            payloads[i] = this.camelContext.getTypeConverter().convertTo(this.payloadsTypes[i], payloads[i]);
        }
        return this.doOnRdd(rdd, payloads);
    }

    public abstract T doOnRdd(JavaRDDLike var1, Object ... var2);
}

