/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.sparkrest.SparkEndpoint;
import org.apache.camel.util.ObjectHelper;
import spark.Request;
import spark.Response;
import spark.Route;

public class CamelSparkRoute
implements Route {
    private final SparkEndpoint endpoint;
    private final Processor processor;

    public CamelSparkRoute(SparkEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public Object handle(Request request, Response response) {
        Exchange exchange = this.endpoint.createExchange(ExchangePattern.InOut);
        try {
            Message in = this.endpoint.getSparkBinding().toCamelMessage(request, exchange, this.endpoint.getSparkConfiguration());
            exchange.setIn(in);
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        try {
            this.endpoint.getSparkBinding().toSparkResponse(msg, response, this.endpoint.getSparkConfiguration());
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (exchange.hasOut()) {
            return exchange.getOut().getBody();
        }
        return exchange.getIn().getBody();
    }
}

