/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.soroushbot.component.SoroushBotComponent;
import org.apache.camel.component.soroushbot.component.SoroushBotDownloadFileProducer;
import org.apache.camel.component.soroushbot.component.SoroushBotMultiThreadConsumer;
import org.apache.camel.component.soroushbot.component.SoroushBotSendMessageProducer;
import org.apache.camel.component.soroushbot.component.SoroushBotSingleThreadConsumer;
import org.apache.camel.component.soroushbot.component.SoroushBotUploadFileProducer;
import org.apache.camel.component.soroushbot.models.SoroushAction;
import org.apache.camel.component.soroushbot.models.SoroushMessage;
import org.apache.camel.component.soroushbot.models.response.UploadFileResponse;
import org.apache.camel.component.soroushbot.service.SoroushService;
import org.apache.camel.component.soroushbot.utils.ExponentialBackOffStrategy;
import org.apache.camel.component.soroushbot.utils.FixedBackOffStrategy;
import org.apache.camel.component.soroushbot.utils.LinearBackOffStrategy;
import org.apache.camel.component.soroushbot.utils.MaximumConnectionRetryReachedException;
import org.apache.camel.component.soroushbot.utils.SoroushException;
import org.apache.camel.component.soroushbot.utils.StringUtils;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.support.task.budget.backoff.BackOffStrategy;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.0", scheme="soroush", title="Soroush", syntax="soroush:action", category={Category.CHAT})
public class SoroushBotEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SoroushBotEndpoint.class);
    @UriPath(name="action", description="The action to do.")
    @Metadata(required=true)
    private SoroushAction action;
    @UriParam(label="security", description="The authorization token for using the bot. if uri path does not contain authorization token, this token will be used.", secret=true)
    private String authorizationToken;
    @UriParam(label="common", description="Connection timeout in ms when connecting to soroush API", defaultValue="30000")
    private int connectionTimeout = 30000;
    @UriParam(label="common", description="Maximum connection retry when fail to connect to soroush API, if the quota is reached, `MaximumConnectionRetryReachedException` is thrown for that message.", defaultValue="4")
    private int maxConnectionRetry = 4;
    @UriParam(label="consumer", description="Number of Thread created by consumer in the route. if you use this method for parallelism, it is guaranteed that messages from same user always execute in the same thread and therefore messages from the same user are processed sequentially", defaultValue="1", defaultValueNote="using SoroushBotSingleThreadConsumer")
    private int concurrentConsumers = 1;
    @UriParam(label="consumer", description="Maximum capacity of each queue when `concurrentConsumers` is greater than 1. if a queue become full, every message that should go to that queue will be dropped. If `bridgeErrorHandler` is set to `true`, an exchange with `CongestionException` is directed to ErrorHandler. You can then processed the error using `onException(CongestionException.class)` route", defaultValue="0", defaultValueNote="infinite capacity")
    private int queueCapacityPerThread;
    @UriParam(label="producer", description="Automatically upload attachments when a message goes to the sendMessage endpoint and the `SoroushMessage.file` (`SoroushMessage.thumbnail`) has been set and `SoroushMessage.fileUrl`(`SoroushMessage.thumbnailUrl`) is null", defaultValue="true")
    private boolean autoUploadFile = true;
    @UriParam(label="producer", description="Force to  upload `SoroushMessage.file`(`SoroushMessage.thumbnail`) if exists, even if the `SoroushMessage.fileUrl`(`SoroushMessage.thumbnailUrl`) is not null in the message", defaultValue="false")
    private boolean forceUpload;
    @UriParam(label="producer", description="If true, when downloading an attached file, thumbnail will be downloaded if provided in the message. Otherwise, only the file will be downloaded ", defaultValue="true")
    private boolean downloadThumbnail = true;
    @UriParam(label="producer", description="Force to download `SoroushMessage.fileUrl`(`SoroushMessage.thumbnailUrl`) if exists, even if the `SoroushMessage.file`(`SoroushMessage.thumbnail`) was not null in that message", defaultValue="false")
    private boolean forceDownload;
    @UriParam(label="producer", description="Automatically download `SoroushMessage.fileUrl` and `SoroushMessage.thumbnailUrl` if exists for the message and store them in `SoroushMessage.file` and `SoroushMessage.thumbnail` field ", defaultValue="false")
    private boolean autoDownload;
    @UriParam(label="scheduling", description="Waiting time before retry failed request (Millisecond). If backOffStrategy is not Fixed this is the based value for computing back off waiting time. the first retry is always happen immediately after failure and retryWaitingTime do not apply to the first retry.", defaultValue="1000")
    private long retryWaitingTime = 1000L;
    @UriParam(label="scheduling", description="The strategy to backoff in case of connection failure. Currently 3 strategies are supported: 1. `Exponential` (default): It multiply `retryWaitingTime` by `retryExponentialCoefficient` after each connection failure. 2. `Linear`: It increase `retryWaitingTime` by `retryLinearIncrement` after each connection failure. 3. `Fixed`: Always use `retryWaitingTime` as the time between retries.", defaultValue="Exponential")
    private String backOffStrategy = "Exponential";
    @UriParam(label="scheduling", description="Coefficient to compute back off time when using `Exponential` Back Off strategy", defaultValue="2")
    private long retryExponentialCoefficient = 2L;
    @UriParam(label="scheduling", description="The amount of time (in millisecond) which adds to waiting time when using `Linear` back off strategy", defaultValue="10000", javaType="java.time.Duration")
    private long retryLinearIncrement = 10000L;
    @UriParam(label="scheduling", description="Maximum amount of time (in millisecond) a thread wait before retrying failed request.", defaultValue="3600000", javaType="java.time.Duration")
    private long maxRetryWaitingTime = 3600000L;
    @UriParam(label="scheduling", description="The timeout in millisecond to reconnect the existing getMessage connection to ensure that the connection is always live and does not dead without notifying the bot. this value should not be changed.", defaultValue="300000", javaType="java.time.Duration")
    private long reconnectIdleConnectionTimeout = 300000L;
    private volatile WebTarget uploadFileTarget;
    private volatile WebTarget sendMessageTarget;
    private BackOffStrategy backOffStrategyHelper;

    public SoroushBotEndpoint(String endpointUri, SoroushBotComponent component) {
        super(endpointUri, (Component)component);
    }

    private String getSupportedEndpointAsString() {
        return "[" + String.join((CharSequence)", ", this.getSupportedEndpoint().stream().map(SoroushAction::value).collect(Collectors.toList())) + "]";
    }

    private List<SoroushAction> getSupportedEndpoint() {
        return Arrays.asList(SoroushAction.values());
    }

    void updatePathConfiguration(String remaining, String defaultAuthorizationToken, String uri) {
        if (remaining == null) {
            throw new IllegalArgumentException("Unexpected URI format. Expected soroush://" + this.getSupportedEndpointAsString() + "[/<authorizationToken>][?options]', found " + uri);
        }
        List<String> pathParts = Arrays.asList(remaining.split("/"));
        for (int i = pathParts.size() - 1; i >= 0; --i) {
            if (!pathParts.get(i).trim().isEmpty()) continue;
            pathParts.remove(i);
        }
        if (pathParts.size() > 2 || pathParts.isEmpty()) {
            throw new IllegalArgumentException("Unexpected URI format. Expected soroush://" + this.getSupportedEndpointAsString() + "[/<authorizationToken>][?options]', found " + uri);
        }
        for (SoroushAction supported : this.getSupportedEndpoint()) {
            if (!supported.value().equals(pathParts.get(0))) continue;
            this.action = supported;
        }
        if (this.action == null) {
            throw new IllegalArgumentException("Unexpected URI format. Expected soroush://" + this.getSupportedEndpointAsString() + "[/<authorizationToken>][?options]', found " + uri);
        }
        if (this.authorizationToken == null) {
            String authorizationToken = defaultAuthorizationToken;
            if (pathParts.size() > 1) {
                authorizationToken = pathParts.get(1);
            }
            this.authorizationToken = authorizationToken;
        }
        if (this.authorizationToken == null || this.authorizationToken.trim().isEmpty()) {
            throw new IllegalArgumentException("The authorization token must be provided and cannot be empty");
        }
    }

    void normalizeConfiguration() {
        if (this.reconnectIdleConnectionTimeout <= 0L) {
            this.reconnectIdleConnectionTimeout = 300000L;
        }
        this.connectionTimeout = Math.max(0, this.connectionTimeout);
        this.maxConnectionRetry = Math.max(0, this.maxConnectionRetry);
        this.retryExponentialCoefficient = Math.max(1L, this.retryExponentialCoefficient);
        this.retryLinearIncrement = Math.max(0L, this.retryLinearIncrement);
        this.backOffStrategyHelper = this.backOffStrategy.equalsIgnoreCase("fixed") ? new FixedBackOffStrategy(this.retryWaitingTime, this.maxRetryWaitingTime) : (this.backOffStrategy.equalsIgnoreCase("linear") ? new LinearBackOffStrategy(this.retryWaitingTime, this.retryLinearIncrement) : new ExponentialBackOffStrategy(this.retryWaitingTime, this.retryExponentialCoefficient));
    }

    public Producer createProducer() {
        if (this.action == SoroushAction.sendMessage) {
            return new SoroushBotSendMessageProducer(this);
        }
        if (this.action == SoroushAction.uploadFile) {
            return new SoroushBotUploadFileProducer(this);
        }
        if (this.action == SoroushAction.downloadFile) {
            return new SoroushBotDownloadFileProducer(this);
        }
        throw new IllegalArgumentException("only [" + (Object)((Object)SoroushAction.sendMessage) + ", " + (Object)((Object)SoroushAction.downloadFile) + ", " + (Object)((Object)SoroushAction.uploadFile) + "] supported for producer(from) and process");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.action != SoroushAction.getMessage) {
            throw new IllegalArgumentException("only " + (Object)((Object)SoroushAction.getMessage) + " support for consumer(from)");
        }
        if (this.concurrentConsumers < 2) {
            SoroushBotSingleThreadConsumer consumer = new SoroushBotSingleThreadConsumer(this, processor);
            return consumer;
        }
        SoroushBotMultiThreadConsumer consumer = new SoroushBotMultiThreadConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    private WebTarget getDownloadFileTarget(String fileUrl) {
        return SoroushService.get().createDownloadFileTarget(this.authorizationToken, fileUrl, this.connectionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebTarget getUploadFileTarget() {
        WebTarget result = this.uploadFileTarget;
        if (result == null) {
            SoroushBotEndpoint soroushBotEndpoint = this;
            synchronized (soroushBotEndpoint) {
                result = this.uploadFileTarget;
                if (result == null) {
                    this.uploadFileTarget = result = SoroushService.get().createUploadFileTarget(this.authorizationToken, this.connectionTimeout);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebTarget getSendMessageTarget() {
        WebTarget result = this.sendMessageTarget;
        if (result == null) {
            SoroushBotEndpoint soroushBotEndpoint = this;
            synchronized (soroushBotEndpoint) {
                result = this.sendMessageTarget;
                if (result == null) {
                    this.sendMessageTarget = result = SoroushService.get().createSendMessageTarget(this.authorizationToken, this.connectionTimeout);
                }
            }
        }
        return result;
    }

    public SoroushAction getAction() {
        return this.action;
    }

    public void setAction(SoroushAction action) {
        this.action = action;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxConnectionRetry() {
        return this.maxConnectionRetry;
    }

    public void setMaxConnectionRetry(int maxConnectionRetry) {
        this.maxConnectionRetry = maxConnectionRetry;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getQueueCapacityPerThread() {
        return this.queueCapacityPerThread;
    }

    public void setQueueCapacityPerThread(int queueCapacityPerThread) {
        this.queueCapacityPerThread = queueCapacityPerThread;
    }

    public boolean isAutoUploadFile() {
        return this.autoUploadFile;
    }

    public void setAutoUploadFile(boolean autoUploadFile) {
        this.autoUploadFile = autoUploadFile;
    }

    public boolean isForceUpload() {
        return this.forceUpload;
    }

    public void setForceUpload(boolean forceUpload) {
        this.forceUpload = forceUpload;
    }

    public boolean isDownloadThumbnail() {
        return this.downloadThumbnail;
    }

    public void setDownloadThumbnail(boolean downloadThumbnail) {
        this.downloadThumbnail = downloadThumbnail;
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public void setForceDownload(boolean forceDownload) {
        this.forceDownload = forceDownload;
    }

    public boolean isAutoDownload() {
        return this.autoDownload;
    }

    public void setAutoDownload(boolean autoDownload) {
        this.autoDownload = autoDownload;
    }

    public long getRetryWaitingTime() {
        return this.retryWaitingTime;
    }

    public void setRetryWaitingTime(long retryWaitingTime) {
        this.retryWaitingTime = retryWaitingTime;
    }

    public String getBackOffStrategy() {
        return this.backOffStrategy;
    }

    public void setBackOffStrategy(String backOffStrategy) {
        this.backOffStrategy = backOffStrategy;
    }

    public long getRetryExponentialCoefficient() {
        return this.retryExponentialCoefficient;
    }

    public void setRetryExponentialCoefficient(long retryExponentialCoefficient) {
        this.retryExponentialCoefficient = retryExponentialCoefficient;
    }

    public long getRetryLinearIncrement() {
        return this.retryLinearIncrement;
    }

    public void setRetryLinearIncrement(long retryLinearIncrement) {
        this.retryLinearIncrement = retryLinearIncrement;
    }

    public long getMaxRetryWaitingTime() {
        return this.maxRetryWaitingTime;
    }

    public void setMaxRetryWaitingTime(long maxRetryWaitingTime) {
        this.maxRetryWaitingTime = maxRetryWaitingTime;
    }

    public long getReconnectIdleConnectionTimeout() {
        return this.reconnectIdleConnectionTimeout;
    }

    public void setReconnectIdleConnectionTimeout(long reconnectIdleConnectionTimeout) {
        this.reconnectIdleConnectionTimeout = reconnectIdleConnectionTimeout;
    }

    public void setUploadFileTarget(WebTarget uploadFileTarget) {
        this.uploadFileTarget = uploadFileTarget;
    }

    public void setSendMessageTarget(WebTarget sendMessageTarget) {
        this.sendMessageTarget = sendMessageTarget;
    }

    public BackOffStrategy getBackOffStrategyHelper() {
        return this.backOffStrategyHelper;
    }

    public void setBackOffStrategyHelper(BackOffStrategy backOffStrategyHelper) {
        this.backOffStrategyHelper = backOffStrategyHelper;
    }

    private UploadFileResponse uploadToServer(InputStream inputStream, SoroushMessage message, String fileType) {
        Payload payload = new Payload(inputStream, message, fileType);
        BlockingTask task = (BlockingTask)Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(this.maxConnectionRetry).withBackOffStrategy(this.backOffStrategyHelper).build()).withName("upload-to-server").build();
        if (!task.run(this::doUploadToServer, (Object)payload)) {
            LOG.error("Exhausted all retries trying to upload data");
            throw new MaximumConnectionRetryReachedException("Uploading " + fileType + " for message " + message + " failed. Maximum retry limit reached! aborting upload file and send message", payload.exception, message);
        }
        return payload.response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doUploadToServer(Payload payload) {
        try (MultiPart multipart = new MultiPart();){
            multipart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
            multipart.bodyPart((BodyPart)new StreamDataBodyPart("file", payload.inputStream, null, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to upload {} for message: {}", (Object)payload.fileType, (Object)payload.message);
            }
            Response response = this.getUploadFileTarget().request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()));
            payload.response = SoroushService.get().assertSuccessful(response, UploadFileResponse.class, payload.message);
            boolean bl = true;
            return bl;
        }
        catch (IOException | ProcessingException | SoroushException ex) {
            payload.exception = (Exception)ex;
            return false;
        }
    }

    void handleFileUpload(SoroushMessage message) {
        InputStream thumbnail;
        LOG.trace("try to upload file(s) to server if exists for message: {}", (Object)message);
        InputStream file = message.getFile();
        if (file != null && (message.getFileUrl() == null || this.forceUpload)) {
            LOG.debug("uploading file to server for message: {}", (Object)message);
            UploadFileResponse response = this.uploadToServer(file, message, "file");
            message.setFileUrl(response.getFileUrl());
            LOG.debug("uploaded file url is: {} for message: {}", (Object)response.getFileUrl(), (Object)message);
        }
        if ((thumbnail = message.getThumbnail()) != null && message.getThumbnailUrl() == null) {
            LOG.debug("uploading thumbnail to server for message: {}", (Object)message);
            UploadFileResponse response = this.uploadToServer(thumbnail, message, "thumbnail");
            message.setThumbnailUrl(response.getFileUrl());
            LOG.debug("uploaded thumbnail url is: {} for message: {}", (Object)response.getFileUrl(), (Object)message);
        }
    }

    public void handleDownloadFiles(SoroushMessage message) throws SoroushException {
        InputStream inputStream;
        if (message.getFileUrl() != null && (message.getFile() == null || this.forceDownload)) {
            LOG.debug("downloading file from server for message: {}", (Object)message);
            inputStream = this.downloadFromServer(message.getFileUrl(), message, "file");
            message.setFile(inputStream);
            LOG.debug("file successfully downloaded for message: {}", (Object)message);
        }
        if (this.downloadThumbnail && message.getThumbnailUrl() != null && (message.getThumbnail() == null || this.forceDownload)) {
            LOG.debug("downloading thumbnail from server for message: {}", (Object)message);
            inputStream = this.downloadFromServer(message.getThumbnailUrl(), message, "thumbnail");
            message.setThumbnail(inputStream);
            LOG.debug("thumbnail successfully downloaded for message: {}", (Object)message);
        }
    }

    private InputStream downloadFromServer(String fileUrl, SoroushMessage message, String type) throws SoroushException {
        Response response = null;
        for (int i = 0; i <= this.maxConnectionRetry; ++i) {
            WebTarget target = this.getDownloadFileTarget(fileUrl);
            if (LOG.isDebugEnabled()) {
                if (i != 0) {
                    LOG.debug("retry downloading {}: {} for the {} time", new Object[]{type, fileUrl, StringUtils.ordinal(i)});
                }
                LOG.debug("try to download {}: {} with url: {}\nfor message: {}", new Object[]{type, fileUrl, target.getUri(), message});
            }
            try {
                response = target.request().get();
                return SoroushService.get().assertSuccessful(response, InputStream.class, message);
            }
            catch (IOException | ProcessingException ex) {
                if (i == this.maxConnectionRetry) {
                    throw new MaximumConnectionRetryReachedException("maximum connection retry reached for " + type + ": " + fileUrl, ex, message);
                }
                LOG.warn("can not download {}: {} from soroush. Response code is {}", new Object[]{type, fileUrl, ex.getMessage()});
                continue;
            }
        }
        LOG.error("should never reach this line. An exception should have been thrown by catch block for target.request().get");
        throw new MaximumConnectionRetryReachedException("can not upload " + type + ": " + fileUrl + " response:" + (response == null ? null : Integer.valueOf(response.getStatus())), message);
    }

    class Payload {
        private final InputStream inputStream;
        private final SoroushMessage message;
        private final String fileType;
        private UploadFileResponse response;
        private Exception exception;

        public Payload(InputStream inputStream, SoroushMessage message, String fileType) {
            this.inputStream = inputStream;
            this.message = message;
            this.fileType = fileType;
        }
    }
}

