/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.utils;

import org.apache.camel.component.soroushbot.utils.BackOffStrategy;

public class LinearBackOffStrategy
implements BackOffStrategy {
    Long retryWaitingTime;
    Long increment;
    Long maxRetryWaitingTime;

    public LinearBackOffStrategy(Long retryWaitingTime, Long increment, Long maxRetryWaitingTime) {
        this.retryWaitingTime = retryWaitingTime;
        this.increment = increment;
        this.maxRetryWaitingTime = maxRetryWaitingTime;
    }

    @Override
    public void waitBeforeRetry(int retryCount) throws InterruptedException {
        if ((retryCount -= 2) >= 0) {
            Thread.sleep(this.retryWaitingTime + this.increment * (long)retryCount);
        }
    }
}

