/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr.converter;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrOperation;
import org.apache.camel.component.solr.SolrProducer;
import org.apache.camel.component.solr.SolrUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.beans.BindingException;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.SolrPing;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

@Converter(generateLoader=true)
public final class SolrRequestConverter {
    public static final String DEFAULT_UPDATE_REQUEST_HANDLER = "/update";

    private SolrRequestConverter() {
    }

    @Converter
    public static SolrPing createSolrPing(Object body, Exchange exchange) {
        return new SolrPing();
    }

    @Converter
    public static QueryRequest createQueryRequest(Object body, Exchange exchange) {
        String requestHandler;
        Integer size;
        SolrQuery solrQuery;
        if (body instanceof QueryRequest) {
            QueryRequest queryRequest = (QueryRequest)body;
            return queryRequest;
        }
        if (body instanceof SolrQuery) {
            SolrQuery solrQuery1;
            solrQuery = solrQuery1 = (SolrQuery)body;
        } else {
            String queryString = (String)exchange.getMessage().getHeader("CamelSolrQueryString", String.class);
            if (ObjectHelper.isEmpty((String)queryString)) {
                queryString = (String)exchange.getMessage().getBody(String.class);
            }
            solrQuery = new SolrQuery(queryString);
        }
        SolrProducer.ActionContext ctx = (SolrProducer.ActionContext)exchange.getProperty("SolrActionContext", SolrProducer.ActionContext.class);
        SolrConfiguration configuration = ctx.configuration();
        Integer from = (Integer)exchange.getMessage().getHeader("CamelSolrFrom", (Object)configuration.getFrom(), Integer.class);
        if (from != null) {
            solrQuery.setStart(from);
        }
        if ((size = (Integer)exchange.getMessage().getHeader("CamelSolrSize", (Object)configuration.getSize(), Integer.class)) != null) {
            solrQuery.setRows(size);
        }
        if ((requestHandler = ctx.requestHandler()) != null) {
            solrQuery.add("qt", new String[]{requestHandler});
        }
        solrQuery.add((SolrParams)ctx.solrParams());
        return new QueryRequest((SolrParams)solrQuery);
    }

    public static boolean isUseContentStreamUpdateRequest(SolrProducer.ActionContext ctx) {
        if (!SolrOperation.INSERT.equals((Object)ctx.operation())) {
            return false;
        }
        Object body = ctx.exchange().getMessage().getBody();
        if (body instanceof String) {
            String bodyAsString = (String)body;
            String contentType = (String)ctx.exchange().getMessage().getHeader("Content-Type", String.class);
            if (ObjectHelper.isEmpty((String)contentType)) {
                contentType = ContentStreamBase.StringStream.detect((String)bodyAsString);
            }
            if (ObjectHelper.isEmpty((String)contentType)) {
                return false;
            }
            SolrRequestConverter.appendAddCommandToXML(ctx, bodyAsString, contentType);
            return true;
        }
        return body instanceof File || body instanceof WrappedFile;
    }

    private static ContentStreamUpdateRequest createNewContentStreamUpdateRequest(SolrProducer.ActionContext ctx) {
        ContentStreamUpdateRequest updateRequest = ctx.requestHandler() != null ? new ContentStreamUpdateRequest(ctx.requestHandler()) : new ContentStreamUpdateRequest(DEFAULT_UPDATE_REQUEST_HANDLER);
        updateRequest.setParams(ctx.solrParams());
        return updateRequest;
    }

    @Converter
    public static ContentStreamUpdateRequest createContentStreamUpdateRequest(Object body, Exchange exchange) throws NoTypeConversionAvailableException {
        SolrProducer.ActionContext ctx = (SolrProducer.ActionContext)exchange.getProperty("SolrActionContext", SolrProducer.ActionContext.class);
        String contentType = (String)ctx.exchange().getMessage().getHeader("Content-Type", String.class);
        ContentStreamUpdateRequest streamUpdateRequest = SolrRequestConverter.createNewContentStreamUpdateRequest(ctx);
        if (body instanceof WrappedFile) {
            WrappedFile wrappedFile = (WrappedFile)body;
            body = wrappedFile.getFile();
        }
        if (body instanceof File) {
            File file = (File)body;
            ContentStreamBase.FileStream stream = new ContentStreamBase.FileStream(file);
            if (ObjectHelper.isEmpty((String)contentType)) {
                contentType = stream.getContentType();
            }
            stream.setContentType(contentType);
            streamUpdateRequest.addContentStream((ContentStream)stream);
            return streamUpdateRequest;
        }
        if (body instanceof String) {
            String string = (String)body;
            ContentStreamBase.StringStream stream = ObjectHelper.isEmpty((String)contentType) ? new ContentStreamBase.StringStream(string) : new ContentStreamBase.StringStream(string, contentType);
            streamUpdateRequest.addContentStream((ContentStream)stream);
            return streamUpdateRequest;
        }
        throw new NoTypeConversionAvailableException(body, SolrRequestConverter.class);
    }

    private static UpdateRequest createNewUpdateRequest(SolrProducer.ActionContext ctx) {
        UpdateRequest updateRequest = ctx.requestHandler() != null ? new UpdateRequest(ctx.requestHandler()) : new UpdateRequest();
        updateRequest.setParams(ctx.solrParams());
        return updateRequest;
    }

    @Converter
    public static UpdateRequest createUpdateRequest(Object body, Exchange exchange) throws NoTypeConversionAvailableException {
        SolrProducer.ActionContext ctx = (SolrProducer.ActionContext)exchange.getProperty("SolrActionContext", SolrProducer.ActionContext.class);
        switch (ctx.operation()) {
            case DELETE: {
                return SolrRequestConverter.createUpdateRequestForDelete(body, exchange, ctx);
            }
            case INSERT: {
                return SolrRequestConverter.createUpdateRequestForInsert(body, exchange, ctx);
            }
        }
        throw new IllegalArgumentException("CamelSolrOperation value '" + String.valueOf((Object)ctx.operation()) + "' is not implemented");
    }

    private static UpdateRequest createUpdateRequestForDelete(Object body, Exchange exchange, SolrProducer.ActionContext ctx) {
        UpdateRequest updateRequest = SolrRequestConverter.createNewUpdateRequest(ctx);
        boolean deleteByQuery = (Boolean)ctx.exchange().getMessage().getHeader("CamelSolrDeleteByQuery", (Object)ctx.configuration().isDeleteByQuery(), Boolean.class);
        boolean bl = deleteByQuery = deleteByQuery || "DELETE_BY_QUERY".equalsIgnoreCase((String)exchange.getMessage().getHeader("CamelSolrOperation", (Object)"", String.class));
        if (deleteByQuery) {
            if (SolrUtils.isCollectionOfType(body, String.class)) {
                updateRequest.setDeleteQuery(SolrUtils.convertToList((Collection)body));
                return updateRequest;
            }
            return updateRequest.deleteByQuery(String.valueOf(body));
        }
        if (SolrUtils.isCollectionOfType(body, String.class)) {
            return updateRequest.deleteById(SolrUtils.convertToList((Collection)body));
        }
        return updateRequest.deleteById(String.valueOf(body));
    }

    private static UpdateRequest createUpdateRequestForInsert(Object body, Exchange exchange, SolrProducer.ActionContext ctx) throws NoTypeConversionAvailableException {
        Optional<SolrInputDocument> doc;
        UpdateRequest updateRequest = SolrRequestConverter.createNewUpdateRequest(ctx);
        if (body instanceof SolrInputDocument) {
            SolrInputDocument solrInputDocument = (SolrInputDocument)body;
            updateRequest.add(solrInputDocument);
            return updateRequest;
        }
        if (SolrUtils.isCollectionOfType(body, SolrInputDocument.class)) {
            updateRequest.add((Collection)((Object)body));
            return updateRequest;
        }
        if (SolrUtils.isCollectionOfType(body, Map.class)) {
            Optional<Collection<SolrInputDocument>> docs = SolrRequestConverter.getOptionalCollectionOfSolrInputDocument((Collection)((Object)body), exchange);
            docs.ifPresent(arg_0 -> ((UpdateRequest)updateRequest).add(arg_0));
            return updateRequest;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(SolrRequestConverter.getMapFromBody(body));
        map.putAll(SolrRequestConverter.getMapFromHeaderSolrFields(exchange));
        if (!map.isEmpty()) {
            body = map;
        }
        if ((doc = SolrRequestConverter.getOptionalSolrInputDocumentFromMap(body, exchange)).isPresent()) {
            updateRequest.add(doc.get());
            return updateRequest;
        }
        try {
            DocumentObjectBinder binder = new DocumentObjectBinder();
            if (SolrUtils.isCollectionOfType(body, Object.class)) {
                Collection objects = (Collection)((Object)body);
                objects.forEach(o -> updateRequest.add(binder.toSolrInputDocument(o)));
                return updateRequest;
            }
            updateRequest.add(binder.toSolrInputDocument(body));
            return updateRequest;
        }
        catch (BindingException bindingException) {
            if (ctx.solrParams().size() > 0) {
                return updateRequest;
            }
            throw new NoTypeConversionAvailableException(body, SolrRequestConverter.class);
        }
    }

    private static void appendAddCommandToXML(SolrProducer.ActionContext ctx, String bodyAsString, String contentType) {
        if ((contentType.startsWith("text/xml") || contentType.startsWith("application/xml")) && !bodyAsString.startsWith("<add")) {
            ctx.exchange().getMessage().setBody((Object)("<add>" + bodyAsString + "</add>"));
        }
    }

    private static Map<String, Object> getMapFromBody(Object body) {
        if (body instanceof Map) {
            return ((Map)body).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), Map.Entry::getValue));
        }
        return Collections.emptyMap();
    }

    private static Map<String, Object> getMapFromHeaderSolrFields(Exchange exchange) {
        return exchange.getMessage().getHeaders().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("SolrField.")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring("SolrField.".length()), Map.Entry::getValue));
    }

    private static Optional<Collection<SolrInputDocument>> getOptionalCollectionOfSolrInputDocument(Collection<Map<?, ?>> maps, Exchange exchange) {
        ArrayList docs = new ArrayList();
        for (Map<?, ?> map : maps) {
            Optional<SolrInputDocument> doc = SolrRequestConverter.getOptionalSolrInputDocumentFromMap(map, exchange);
            doc.ifPresent(docs::add);
        }
        return docs.isEmpty() ? Optional.empty() : Optional.of(docs);
    }

    private static Optional<SolrInputDocument> getOptionalSolrInputDocumentFromMap(Object body, Exchange exchange) {
        Map<String, Object> map = SolrRequestConverter.getMapFromBody(body);
        if (!map.isEmpty()) {
            SolrInputDocument doc = new SolrInputDocument();
            map.forEach((arg_0, arg_1) -> ((SolrInputDocument)doc).setField(arg_0, arg_1));
            return Optional.of(doc);
        }
        return Optional.empty();
    }
}

