/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Exchange;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.SimpleOrderedMap;

public class SolrUtils {
    public static Map<String, Object> parseAsMap(SolrResponse solrResponse) {
        return solrResponse == null || solrResponse.getResponse() == null ? Map.of() : solrResponse.getResponse().asShallowMap(true);
    }

    public static Map<String, Object> parseAsFlatMap(SolrResponse solrResponse) {
        return SolrUtils.parseAsFlatMap(SolrUtils.parseAsMap(solrResponse));
    }

    public static Map<String, Object> parseAsFlatMap(Map<String, Object> map1) {
        return SolrUtils.parseAsFlatMap(map1, null, null);
    }

    public static Map<String, Object> parseAsFlatMap(Map<String, Object> map1, String startsWith, String endsWith) {
        return map1.entrySet().stream().flatMap(SolrUtils::flatten).filter(e -> e != null && e.getKey() != null && e.getValue() != null).filter(e -> startsWith == null || ((String)e.getKey()).startsWith(startsWith)).filter(e -> endsWith == null || ((String)e.getKey()).endsWith(endsWith)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Stream<Map.Entry<String, Object>> flatten(Map.Entry<String, Object> entry) {
        Map nestedMap = null;
        Object object = entry.getValue();
        if (object instanceof SimpleOrderedMap) {
            SimpleOrderedMap nested = (SimpleOrderedMap)object;
            nestedMap = nested.asShallowMap(true);
        } else {
            object = entry.getValue();
            if (object instanceof Map) {
                Map nested;
                nestedMap = nested = (Map)object;
            }
        }
        if (nestedMap != null) {
            return nestedMap.entrySet().stream().map(e -> new AbstractMap.SimpleEntry((CallSite)((Object)((String)entry.getKey() + "." + (String)e.getKey())), e.getValue())).flatMap(SolrUtils::flatten);
        }
        return Stream.of(entry);
    }

    public static void addHeadersForCommit(ModifiableSolrParams solrParams) {
        SolrUtils.getHeadersForCommit("commit", null).forEach((k, v) -> solrParams.add(k, new String[]{String.valueOf(v)}));
    }

    public static void addHeadersForCommit(Exchange exchange) {
        SolrUtils.addHeadersForCommit(exchange, "commit");
    }

    public static void addHeadersForCommit(Exchange exchange, String commitParam) {
        exchange.getMessage().getHeaders().putAll(SolrUtils.getHeadersForCommit(commitParam));
    }

    public static Map<String, Object> getHeadersForCommit() {
        return SolrUtils.getHeadersForCommit("commit");
    }

    public static Map<String, Object> getHeadersForCommit(String commitParam) {
        return SolrUtils.getHeadersForCommit(commitParam, "SolrParam.");
    }

    public static Map<String, Object> getHeadersForCommit(String commitParam, String prefix) {
        String finalPrefix = prefix == null ? "" : prefix;
        return Map.of(finalPrefix + commitParam, "true");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isCollectionOfType(Object body, Class<?> clazz) {
        if (!(body instanceof Collection)) return false;
        Collection collection = (Collection)body;
        if (!collection.stream().allMatch(clazz::isInstance)) return false;
        return true;
    }

    public static <T> List<T> convertToList(Collection<T> collection) {
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }
}

