/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.component.solr.SolrClientHandlerCloud;
import org.apache.camel.component.solr.SolrClientHandlerConcurrentUpdate;
import org.apache.camel.component.solr.SolrClientHandlerHttp;
import org.apache.camel.component.solr.SolrClientHandlerLbHttp;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.util.StringHelper;
import org.apache.solr.client.solrj.SolrClient;

public abstract class SolrClientHandler {
    public final SolrConfiguration solrConfiguration;

    public SolrClientHandler(SolrConfiguration solrConfiguration) {
        this.solrConfiguration = solrConfiguration;
    }

    protected abstract SolrClient getSolrClient();

    protected static Optional<String> getZkChrootFromUrl(String path) {
        if (!(path = StringHelper.removeStartingCharacters((String)path, (char)'/')).contains("/")) {
            return Optional.empty();
        }
        String pathWithZkChroot = Arrays.stream(path.split(",")).filter(s -> s.contains("/")).findFirst().orElse("");
        return Arrays.asList(pathWithZkChroot.split("/")).get(1).equals("solr") ? Optional.empty() : Optional.of(pathWithZkChroot.substring(pathWithZkChroot.indexOf(47)));
    }

    protected static String parseHostsFromUrl(String path, Optional<String> zkChroot) {
        String hostsPath = StringHelper.removeStartingCharacters((String)path, (char)'/');
        return zkChroot.isPresent() ? hostsPath.substring(0, hostsPath.indexOf(47)) : hostsPath;
    }

    protected String getFirstUrlFromList() {
        return SolrClientHandler.getUrlListFrom(this.solrConfiguration).get(0);
    }

    protected static List<String> getUrlListFrom(SolrConfiguration solrConfiguration) {
        String url = solrConfiguration.getZkHost() != null && !solrConfiguration.getZkHost().isEmpty() ? solrConfiguration.getZkHost() : solrConfiguration.getUrl();
        List<String> urlList = Arrays.asList(url.split(",")).stream().map(s -> solrConfiguration.getSolrScheme().getScheme().concat((String)s)).collect(Collectors.toList());
        for (String s2 : urlList) {
            try {
                new URL(SolrConfiguration.SolrScheme.SOLRCLOUD.equals((Object)solrConfiguration.getSolrScheme()) ? SolrConfiguration.SolrScheme.SOLR.getScheme().concat(s2) : s2);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(String.format("Url '%s' not valid for endpoint with uri=%s", s2, solrConfiguration.getSolrScheme().getUri()));
            }
        }
        return urlList;
    }

    public static String getSignature(SolrConfiguration solrConfiguration) {
        if (solrConfiguration.getSolrClient() != null) {
            return solrConfiguration.getSolrClient().toString();
        }
        StringBuilder sb = new StringBuilder();
        if (solrConfiguration.getSolrEndpoint() != null) {
            sb.append((Object)solrConfiguration.getSolrEndpoint());
        }
        if (solrConfiguration.getUseConcurrentUpdateSolrClient()) {
            sb.append("_");
            sb.append(solrConfiguration.getUseConcurrentUpdateSolrClient());
        }
        return sb.toString();
    }

    public static SolrConfiguration initializeFor(String solrOperation, SolrConfiguration solrConfiguration) {
        if (solrOperation == null) {
            return solrConfiguration;
        }
        switch (solrOperation) {
            case "INSERT_STREAMING": {
                if (!SolrConfiguration.SolrScheme.SOLRCLOUD.equals((Object)solrConfiguration.getSolrScheme())) {
                    SolrConfiguration newSolrConfiguration = solrConfiguration.deepCopy();
                    newSolrConfiguration.setUseConcurrentUpdateSolrClient(true);
                    return newSolrConfiguration;
                }
                return solrConfiguration;
            }
        }
        return solrConfiguration;
    }

    protected static SolrClient getSolrClient(SolrConfiguration solrConfiguration) {
        if (solrConfiguration.getSolrClient() != null) {
            return solrConfiguration.getSolrClient();
        }
        SolrClientHandler solrClientHandler = null;
        List<String> urlList = SolrClientHandler.getUrlListFrom(solrConfiguration);
        solrClientHandler = SolrConfiguration.SolrScheme.SOLRCLOUD.equals((Object)solrConfiguration.getSolrScheme()) ? new SolrClientHandlerCloud(solrConfiguration) : (urlList.size() > 1 ? new SolrClientHandlerLbHttp(solrConfiguration) : (solrConfiguration.getUseConcurrentUpdateSolrClient() ? new SolrClientHandlerConcurrentUpdate(solrConfiguration) : new SolrClientHandlerHttp(solrConfiguration)));
        return ((SolrClientHandler)solrClientHandler).getSolrClient();
    }
}

