/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.component.snmp.SnmpMessage;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapConsumer
extends DefaultConsumer
implements CommandResponder {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpTrapConsumer.class);
    private final SnmpEndpoint endpoint;
    private TransportMapping<? extends Address> transport;

    public SnmpTrapConsumer(SnmpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting trap consumer on {}", (Object)this.endpoint.getServerAddress());
        }
        Address listenGenericAddress = GenericAddress.parse((String)this.endpoint.getServerAddress());
        if ("tcp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultTcpTransportMapping((TcpAddress)listenGenericAddress);
        } else if ("udp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultUdpTransportMapping((UdpAddress)listenGenericAddress);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
        }
        Snmp snmp = new Snmp(this.transport);
        snmp.addCommandResponder((CommandResponder)this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting trap consumer on {} using {} protocol", (Object)this.endpoint.getServerAddress(), (Object)this.endpoint.getProtocol());
        }
        this.transport.listen();
        if (LOG.isInfoEnabled()) {
            LOG.info("Started trap consumer on {} using {} protocol", (Object)this.endpoint.getServerAddress(), (Object)this.endpoint.getProtocol());
        }
    }

    protected void doStop() throws Exception {
        if (this.transport != null && this.transport.isListening()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping trap consumer on {}", (Object)this.endpoint.getServerAddress());
            }
            this.transport.close();
            LOG.info("Stopped trap consumer on {}", (Object)this.endpoint.getServerAddress());
        }
        super.doStop();
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu != null) {
            if (pdu.getType() != -89 && pdu.getType() != -92 && pdu.getType() != -88 && pdu.getType() != -94) {
                pdu.setErrorIndex(0);
                pdu.setErrorStatus(0);
                pdu.setType(-94);
                StatusInformation statusInformation = new StatusInformation();
                StateReference ref = event.getStateReference();
                try {
                    event.getMessageDispatcher().returnResponsePdu(event.getMessageProcessingModel(), event.getSecurityModel(), event.getSecurityName(), event.getSecurityLevel(), pdu, event.getMaxSizeResponsePDU(), ref, statusInformation);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("response to INFORM sent");
                    }
                }
                catch (MessageException ex) {
                    this.getExceptionHandler().handleException((Throwable)ex);
                }
            }
            this.processPDU(pdu, event);
        } else {
            LOG.debug("Received invalid trap PDU");
        }
    }

    public void processPDU(PDU pdu, CommandResponderEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received trap event for {} : {}", (Object)this.endpoint.getServerAddress(), (Object)pdu);
        }
        Exchange exchange = this.createExchange(pdu, event);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException((Throwable)exchange.getException());
        }
        this.releaseExchange(exchange, false);
    }

    public Exchange createExchange(PDU pdu, CommandResponderEvent event) {
        Exchange exchange = this.createExchange(false);
        exchange.setIn((Message)new SnmpMessage(this.getEndpoint().getCamelContext(), pdu, event));
        return exchange;
    }
}

