/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SnmpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "snmp".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(38);
        props.add("authenticationPassphrase");
        props.add("authenticationProtocol");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("delay");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("greedy");
        props.add("host");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("oids");
        props.add("pollStrategy");
        props.add("port");
        props.add("privacyPassphrase");
        props.add("privacyProtocol");
        props.add("protocol");
        props.add("repeatCount");
        props.add("retries");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("securityLevel");
        props.add("securityName");
        props.add("sendEmptyMessageWhenIdle");
        props.add("snmpCommunity");
        props.add("snmpContextEngineId");
        props.add("snmpContextName");
        props.add("snmpVersion");
        props.add("startScheduler");
        props.add("timeUnit");
        props.add("timeout");
        props.add("treeList");
        props.add("type");
        props.add("useFixedDelay");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("authenticationPassphrase");
        secretProps.add("privacyPassphrase");
        secretProps.add("privacyProtocol");
        secretProps.add("securityName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

