/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.util.concurrent.TimeoutException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.component.snmp.SnmpMessage;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpProducer.class);
    private SnmpEndpoint endpoint;
    private Address targetAddress;
    private USM usm;
    private CommunityTarget target;
    private PDU pdu;

    public SnmpProducer(SnmpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.targetAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        LOG.debug("targetAddress: {}", (Object)this.targetAddress);
        this.usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        this.target = new CommunityTarget();
        this.target.setCommunity(new OctetString(this.endpoint.getSnmpCommunity()));
        this.target.setAddress(this.targetAddress);
        this.target.setRetries(this.endpoint.getRetries());
        this.target.setTimeout((long)this.endpoint.getTimeout());
        this.target.setVersion(this.endpoint.getSnmpVersion());
        this.pdu = new PDU();
        for (OID oid : this.endpoint.getOids()) {
            this.pdu.add(new VariableBinding(oid));
        }
        this.pdu.setErrorIndex(0);
        this.pdu.setErrorStatus(0);
        this.pdu.setMaxRepetitions(0);
        this.pdu.setType(-96);
    }

    protected void doStop() throws Exception {
        super.doStop();
        try {
            SecurityModels.getInstance().removeSecurityModel(new Integer32(this.usm.getID()));
        }
        finally {
            this.targetAddress = null;
            this.usm = null;
            this.target = null;
            this.pdu = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        block16: {
            Snmp snmp = null;
            DefaultTcpTransportMapping transport = null;
            try {
                LOG.debug("Starting SNMP producer on {}", (Object)this.endpoint.getAddress());
                if ("tcp".equals(this.endpoint.getProtocol())) {
                    transport = new DefaultTcpTransportMapping();
                } else if ("udp".equals(this.endpoint.getProtocol())) {
                    transport = new DefaultUdpTransportMapping();
                } else {
                    throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
                }
                snmp = new Snmp((TransportMapping)transport);
                LOG.debug("Snmp: i am sending");
                snmp.listen();
                ResponseEvent responseEvent = snmp.send(this.pdu, (Target)this.target);
                LOG.debug("Snmp: sended");
                if (responseEvent.getResponse() != null) {
                    exchange.getIn().setBody((Object)new SnmpMessage(this.getEndpoint().getCamelContext(), responseEvent.getResponse()));
                    break block16;
                }
                throw new TimeoutException("SNMP Producer Timeout");
            }
            finally {
                try {
                    transport.close();
                }
                catch (Exception exception) {}
                try {
                    snmp.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

