/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppCancelSmCommand;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppDataSmCommand;
import org.apache.camel.component.smpp.SmppQuerySmCommand;
import org.apache.camel.component.smpp.SmppReplaceSmCommand;
import org.apache.camel.component.smpp.SmppSubmitMultiCommand;
import org.apache.camel.component.smpp.SmppSubmitSmCommand;
import org.jsmpp.session.SMPPSession;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SmppCommandType {
    SUBMIT_SM("SubmitSm"){

        @Override
        public SmppSubmitSmCommand createCommand(SMPPSession session, SmppConfiguration config) {
            return new SmppSubmitSmCommand(session, config);
        }
    }
    ,
    REPLACE_SM("ReplaceSm"){

        @Override
        public SmppReplaceSmCommand createCommand(SMPPSession session, SmppConfiguration config) {
            return new SmppReplaceSmCommand(session, config);
        }
    }
    ,
    QUERY_SM("QuerySm"){

        @Override
        public SmppQuerySmCommand createCommand(SMPPSession session, SmppConfiguration config) {
            return new SmppQuerySmCommand(session, config);
        }
    }
    ,
    SUBMIT_MULTI("SubmitMulti"){

        @Override
        public SmppSubmitMultiCommand createCommand(SMPPSession session, SmppConfiguration config) {
            return new SmppSubmitMultiCommand(session, config);
        }
    }
    ,
    CANCEL_SM("CancelSm"){

        @Override
        public SmppCancelSmCommand createCommand(SMPPSession session, SmppConfiguration config) {
            return new SmppCancelSmCommand(session, config);
        }
    }
    ,
    DATA_SHORT_MESSAGE("DataSm"){

        @Override
        public SmppDataSmCommand createCommand(SMPPSession session, SmppConfiguration config) {
            return new SmppDataSmCommand(session, config);
        }
    };

    private final String commandName;

    private SmppCommandType(String commandName) {
        this.commandName = commandName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public abstract SmppCommand createCommand(SMPPSession var1, SmppConfiguration var2);

    public static SmppCommandType fromExchange(Exchange exchange) {
        Message in = exchange.getIn();
        String commandName = null;
        if (in.getHeaders().containsKey("CamelSmppCommand")) {
            commandName = (String)in.getHeader("CamelSmppCommand", String.class);
        }
        SmppCommandType commandType = SUBMIT_SM;
        for (SmppCommandType nextCommandType : SmppCommandType.values()) {
            if (!nextCommandType.commandName.equals(commandName)) continue;
            commandType = nextCommandType;
            break;
        }
        return commandType;
    }
}

