/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConnectionFactory;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.task.BlockingTask;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.jsmpp.util.PDUComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SmppProducer.class);
    private static final String RECONNECT_TASK_NAME = "smpp-producer-reconnect";
    private final SmppConfiguration configuration;
    private final SessionStateListener internalSessionStateListener;
    private final ReentrantLock connectLock = new ReentrantLock();
    private final ScheduledExecutorService reconnectService;
    private SMPPSession session;

    public SmppProducer(SmppEndpoint endpoint, SmppConfiguration config) {
        super((Endpoint)endpoint);
        this.reconnectService = SmppUtils.createExecutor((BaseService)this, (Endpoint)endpoint, RECONNECT_TASK_NAME);
        this.configuration = config;
        this.internalSessionStateListener = (newState, oldState, source) -> {
            if (this.configuration.getSessionStateListener() != null) {
                this.configuration.getSessionStateListener().onStateChange(newState, oldState, source);
            }
            if (newState.equals((Object)SessionState.CLOSED)) {
                LOG.warn("Lost connection to: {} - trying to reconnect...", (Object)this.getEndpoint().getConnectionString());
                this.closeSession();
                this.reconnect(this.configuration.getInitialReconnectDelay());
            }
        };
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.getConfiguration().isLazySessionCreation()) {
            if (this.connectLock.tryLock()) {
                try {
                    this.session = this.createSession();
                }
                finally {
                    this.connectLock.unlock();
                }
            } else {
                LOG.warn("Thread {} could not acquire a lock for creating the session during producer start", (Object)Thread.currentThread().getId());
            }
        }
    }

    private SMPPSession createSession() throws IOException {
        LOG.debug("Connecting to: {}...", (Object)this.getEndpoint().getConnectionString());
        SMPPSession session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer().intValue());
        session.setTransactionTimer((long)this.configuration.getTransactionTimer().intValue());
        session.setPduProcessorDegree(this.configuration.getPduProcessorDegree().intValue());
        session.setQueueCapacity(this.configuration.getPduProcessorQueueCapacity().intValue());
        session.addSessionStateListener(this.internalSessionStateListener);
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort().intValue(), new BindParameter(BindType.BIND_TX, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.valueOf((byte)this.configuration.getTypeOfNumber()), NumberingPlanIndicator.valueOf((byte)this.configuration.getNumberingPlanIndicator()), ""));
        LOG.info("Connected to: {}", (Object)this.getEndpoint().getConnectionString());
        return session;
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession((PDUSender)new SynchronizedPDUSender((PDUSender)new DefaultPDUSender((PDUComposer)new DefaultComposer())), (PDUReader)new DefaultPDUReader(), (ConnectionFactory)SmppConnectionFactory.getInstance(this.configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void process(Exchange exchange) throws Exception {
        if (this.session == null && this.configuration.isLazySessionCreation()) {
            if (this.connectLock.tryLock()) {
                try {
                    if (this.session != null) ** GOTO lbl18
                    in = exchange.getIn();
                    systemId = (String)in.getHeader("CamelSmppSystemId", String.class);
                    password = (String)in.getHeader("CamelSmppPassword", String.class);
                    if (systemId != null && password != null) {
                        SmppProducer.LOG.info("using the system id '{}' to connect to the SMSC...", (Object)systemId);
                        this.configuration.setSystemId(systemId);
                        this.configuration.setPassword(password);
                    }
                    this.session = this.createSession();
                }
                finally {
                    this.connectLock.unlock();
                }
            } else {
                SmppProducer.LOG.warn("Thread {} could not acquire a lock for creating the session during lazy initialization", (Object)Thread.currentThread().getId());
            }
        }
lbl18:
        // 5 sources

        if (this.session == null) {
            throw new IOException("Lost connection to " + this.getEndpoint().getConnectionString() + " and yet not reconnected");
        }
        command = this.getEndpoint().getBinding().createSmppCommand(this.session, exchange);
        command.execute(exchange);
    }

    protected void doStop() throws Exception {
        SmppUtils.shutdownReconnectService(this.reconnectService);
        LOG.debug("Disconnecting from: {}...", (Object)this.getEndpoint().getConnectionString());
        super.doStop();
        this.closeSession();
        LOG.info("Disconnected from: {}", (Object)this.getEndpoint().getConnectionString());
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.removeSessionStateListener(this.internalSessionStateListener);
            this.session.unbindAndClose();
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(long initialReconnectDelay) {
        if (this.connectLock.tryLock()) {
            BlockingTask task = SmppUtils.newReconnectTask(this.reconnectService, RECONNECT_TASK_NAME, initialReconnectDelay, this.configuration.getReconnectDelay(), this.configuration.getMaxReconnect());
            try {
                task.run(this::doReconnect);
            }
            finally {
                this.connectLock.unlock();
            }
        } else {
            LOG.warn("Thread {} could not acquire a lock for creating the session during producer reconnection", (Object)Thread.currentThread().getId());
        }
    }

    private boolean doReconnect() {
        try {
            LOG.info("Trying to reconnect to {}", (Object)this.getEndpoint().getConnectionString());
            if (SmppUtils.isServiceStopping((BaseService)this)) {
                return true;
            }
            if (SmppUtils.isSessionClosed(this.session)) {
                return this.tryCreateSession();
            }
            LOG.info("Nothing to do: the session is not closed");
        }
        catch (Exception e) {
            LOG.error("Unable to reconnect to {}: {}", new Object[]{this.getEndpoint().getConnectionString(), e.getMessage(), e});
            return false;
        }
        return true;
    }

    private boolean tryCreateSession() {
        try {
            this.session = this.createSession();
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to reconnect to {}", (Object)this.getEndpoint().getConnectionString());
            this.closeSession();
            return false;
        }
    }

    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "SmppProducer[" + this.getEndpoint().getConnectionString() + "]";
    }
}

