/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.utils.SmbFiles;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbProducer
extends DefaultProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmbProducer.class);
    private boolean loggedIn;
    private Session session;
    private final SMBClient smbClient;
    HashSet<AccessMask> GENERIC_ALL_ACCESSMASK = new HashSet<AccessMask>(Arrays.asList(AccessMask.GENERIC_ALL));
    HashSet<AccessMask> FILE_WRITE_DATA_ACCESSMASK = new HashSet<AccessMask>(Arrays.asList(AccessMask.FILE_WRITE_DATA));
    HashSet<SMB2CreateOptions> FILE_DIRECTORY_CREATE_OPTIONS = new HashSet<SMB2CreateOptions>(Arrays.asList(SMB2CreateOptions.FILE_DIRECTORY_FILE));
    HashSet<FileAttributes> FILE_ATTRIBUTES_NORMAL = new HashSet<FileAttributes>(Arrays.asList(FileAttributes.FILE_ATTRIBUTE_NORMAL));

    protected SmbProducer(SmbEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.smbClient = this.getEndpoint().getConfiguration().getSmbConfig() != null ? new SMBClient(this.getEndpoint().getConfiguration().getSmbConfig()) : new SMBClient();
    }

    protected void doStop() throws Exception {
        LOGGER.debug("Producer SMB client stopped");
        super.doStop();
    }

    protected void doStart() throws Exception {
        LOGGER.debug("Producer SMB client started");
        super.doStart();
    }

    public String normalize(String file) {
        String result = file.replace('\\', '/');
        LOGGER.debug("Normalize path {} to {}", (Object)file, (Object)result);
        return result;
    }

    private int getReadBufferSize() {
        int readBufferSize = this.getEndpoint().getConfiguration().getReadBufferSize();
        readBufferSize = readBufferSize <= 0 ? 2048 : readBufferSize;
        return readBufferSize;
    }

    protected void connectIfNecessary(Exchange exchange) throws IOException {
        Connection connection = this.smbClient.connect(this.getEndpoint().getHostname(), this.getEndpoint().getPort());
        if (!this.loggedIn) {
            LOGGER.debug("Not already connected/logged in. Connecting to: {}", (Object)this.getEndpoint());
            AuthenticationContext ac = new AuthenticationContext(this.getEndpoint().getConfiguration().getUsername(), this.getEndpoint().getConfiguration().getPassword().toCharArray(), this.getEndpoint().getConfiguration().getDomain());
            this.session = connection.authenticate(ac);
            LOGGER.debug("Connected and logged in to: {}", (Object)this.getEndpoint());
        }
    }

    public void disconnect() throws IOException {
        this.loggedIn = false;
        LOGGER.debug("Disconnecting from: {}", (Object)this.getEndpoint());
        this.session.close();
        this.session = null;
    }

    public void createDirectory(DiskShare share, java.io.File file) {
        String parentDir = file.getParent();
        SmbConfiguration configuration = this.getEndpoint().getConfiguration();
        boolean dirExists = share.folderExists(parentDir);
        if (!dirExists && configuration.isAutoCreate()) {
            SmbFiles files = new SmbFiles();
            files.mkdirs(share, this.normalize(parentDir));
        }
        if (!dirExists) {
            throw new RuntimeCamelException("Directory " + parentDir + " does not exist on share " + share.toString());
        }
    }

    private GenericFileExist determineFileExist(Exchange exchange) {
        GenericFileExist gfe = (GenericFileExist)exchange.getIn().getHeader("CamelSmbFileExists", GenericFileExist.class);
        if (ObjectHelper.isEmpty((Object)gfe)) {
            gfe = this.getEndpoint().getConfiguration().getFileExist();
        }
        gfe = gfe == null ? GenericFileExist.Fail : gfe;
        return gfe;
    }

    private void doFail(String path) {
        throw new RuntimeCamelException("File " + path + " already exists, cannot create");
    }

    private void doIgnore(String path) {
        LOGGER.debug("An existing file already exists: {}. Ignore and do not override it.", (Object)path);
    }

    private void removeFile(DiskShare share, java.io.File file) {
        LOGGER.debug("An existing file already exists: {}. Removing it.", (Object)file.getName());
        share.rm(file.getPath());
    }

    public void process(Exchange exchange) {
        String fileName = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        SmbConfiguration configuration = this.getEndpoint().getConfiguration();
        String path = configuration.getPath() == null ? "" : configuration.getPath();
        try {
            this.connectIfNecessary(exchange);
            java.io.File file = new java.io.File(path, fileName);
            DiskShare share = (DiskShare)this.session.connectShare(this.getEndpoint().getShareName());
            this.createDirectory(share, file);
            GenericFileExist gfe = this.determineFileExist(exchange);
            File shareFile = null;
            switch (gfe) {
                case Override: {
                    shareFile = share.openFile(file.getPath(), this.FILE_WRITE_DATA_ACCESSMASK, this.FILE_ATTRIBUTES_NORMAL, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OVERWRITE_IF, this.FILE_DIRECTORY_CREATE_OPTIONS);
                    break;
                }
                case Append: {
                    shareFile = share.openFile(file.getPath(), this.FILE_WRITE_DATA_ACCESSMASK, this.FILE_ATTRIBUTES_NORMAL, SMB2ShareAccess.ALL, SMB2CreateDisposition.FILE_OPEN_IF, this.FILE_DIRECTORY_CREATE_OPTIONS);
                    break;
                }
                case Ignore: {
                    if (!share.fileExists(file.getPath())) break;
                    this.doIgnore(file.getPath());
                    return;
                }
                case Fail: {
                    if (!share.fileExists(file.getPath())) break;
                    this.doFail(file.getPath());
                    break;
                }
                case Move: {
                    throw new UnsupportedOperationException("Move is not implemented for this producer at the moment");
                }
                case TryRename: {
                    throw new UnsupportedOperationException("TryRename is not implemented for this producer at the moment");
                }
            }
            InputStream is = exchange.getMessage(InputStream.class) == null ? (InputStream)exchange.getMessage().getBody(InputStream.class) : (InputStream)exchange.getMessage(InputStream.class);
            int buffer = this.getReadBufferSize();
            long fileOffset = 0L;
            byte[] byteBuffer = new byte[buffer];
            int length = 0;
            while ((length = is.read(byteBuffer)) > 0) {
                fileOffset = share.getFileInformation(file.getPath()).getStandardInformation().getEndOfFile();
                shareFile.write(byteBuffer, fileOffset, 0, length);
            }
            shareFile.flush();
            shareFile.close();
        }
        catch (IOException ioe) {
            throw new RuntimeCamelException((Throwable)ioe);
        }
    }

    public SmbEndpoint getEndpoint() {
        return (SmbEndpoint)super.getEndpoint();
    }
}

