/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.component.smb.SmbIOBean;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ScheduledPollConsumer;

public class SmbConsumer
extends ScheduledPollConsumer {
    private final SmbEndpoint endpoint;
    private final SmbConfiguration configuration;
    private final SMBClient smbClient = new SMBClient();

    public SmbConsumer(SmbEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
    }

    protected int poll() throws Exception {
        int polledCount = 0;
        try (Connection connection = this.smbClient.connect(this.endpoint.getHostname(), this.endpoint.getPort());){
            AuthenticationContext ac = new AuthenticationContext(this.configuration.getUsername(), this.configuration.getPassword().toCharArray(), this.configuration.getDomain());
            Session session = connection.authenticate(ac);
            try (DiskShare share = (DiskShare)session.connectShare(this.endpoint.getShareName());){
                SmbIOBean smbIOBean = this.configuration.getSmbIoBean();
                IdempotentRepository repository = this.configuration.getIdempotentRepository();
                for (FileIdBothDirectoryInformation f : share.list(this.configuration.getPath(), this.configuration.getSearchPattern())) {
                    if (f.getFileName().equals(".") || f.getFileName().equals("..") || repository.contains(f.getFileName())) continue;
                    ++polledCount;
                    Exchange exchange = this.createExchange(true);
                    File file = share.openFile(f.getFileName(), smbIOBean.accessMask(), smbIOBean.attributes(), smbIOBean.shareAccesses(), smbIOBean.createDisposition(), smbIOBean.createOptions());
                    repository.add(f.getFileName());
                    exchange.getMessage().setBody((Object)file);
                    try {
                        this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        exchange.setException((Throwable)e);
                    }
                    if (exchange.getException() == null) continue;
                    Exception e = exchange.getException();
                    String msg = "Error processing file " + f.getFileName() + " due to " + e.getMessage();
                    this.handleException(msg, exchange, e);
                }
            }
        }
        return polledCount;
    }
}

