/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.smb.SmbComponent;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="4.3.0", scheme="smb", title="SMB", syntax="smb:hostname:port/shareName", consumerOnly=true, category={Category.FILE})
public class SmbEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required=true)
    private String hostname;
    @UriPath(defaultValue="445")
    private int port;
    @UriPath(secret=true)
    private String shareName;
    @UriParam
    private SmbConfiguration configuration = new SmbConfiguration();

    public SmbEndpoint() {
    }

    public SmbEndpoint(String uri, SmbComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() {
        throw new UnsupportedOperationException("SMB producer is not supported.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SmbConsumer consumer = new SmbConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public SmbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SmbConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getShareName() {
        return this.shareName;
    }

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }
}

