/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import com.slack.api.Slack;
import com.slack.api.SlackConfig;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.conversations.ConversationsHistoryResponse;
import com.slack.api.methods.response.conversations.ConversationsListResponse;
import com.slack.api.model.Conversation;
import com.slack.api.model.Message;
import com.slack.api.util.http.SlackHttpClient;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.slack.CustomSlackHttpClient;
import org.apache.camel.component.slack.SlackEndpoint;
import org.apache.camel.component.slack.helper.SlackHelper;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

public class SlackConsumer
extends ScheduledBatchPollingConsumer {
    public static final long DEFAULT_CONSUMER_DELAY = 10000L;
    private static final int CONVERSATIONS_LIST_LIMIT = 200;
    private final SlackEndpoint slackEndpoint;
    private Slack slack;
    private String timestamp;
    private String channelId;

    public SlackConsumer(SlackEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.slackEndpoint = endpoint;
    }

    protected void doStart() throws Exception {
        SlackConfig config = SlackHelper.createSlackConfig(this.slackEndpoint.getServerUrl());
        CustomSlackHttpClient client = new CustomSlackHttpClient();
        this.slack = Slack.getInstance((SlackConfig)config, (SlackHttpClient)client);
        this.channelId = this.getChannelId(this.slackEndpoint.getChannel(), null);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.slack != null) {
            this.slack.close();
        }
    }

    protected int poll() throws Exception {
        ConversationsHistoryResponse response = this.slack.methods(this.slackEndpoint.getToken()).conversationsHistory(req -> req.channel(this.channelId).oldest(this.timestamp).limit(Integer.valueOf(this.timestamp != null ? Integer.parseInt(this.slackEndpoint.getMaxResults()) : 1)));
        if (!response.isOk()) {
            throw new RuntimeCamelException("API request conversations.history to Slack failed: " + response);
        }
        this.forceConsumerAsReady();
        Queue<Exchange> exchanges = this.createExchanges(response.getMessages());
        return this.processBatch(CastUtils.cast(exchanges));
    }

    private Queue<Exchange> createExchanges(List<Message> list) {
        LinkedList<Exchange> answer;
        block6: {
            answer = new LinkedList<Exchange>();
            if (!ObjectHelper.isNotEmpty(list)) break block6;
            if (this.slackEndpoint.isNaturalOrder()) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    Message message = list.get(i);
                    if (i == 0) {
                        this.timestamp = message.getTs();
                    }
                    Exchange exchange = this.createExchange(message);
                    answer.add(exchange);
                }
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    Message message = list.get(i);
                    if (i == 0) {
                        this.timestamp = message.getTs();
                    }
                    Exchange exchange = this.createExchange(message);
                    answer.add(exchange);
                }
            }
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
            this.getAsyncProcessor().process(exchange, cb);
        }
        return total;
    }

    private String getChannelId(String channel, String cursor) {
        try {
            ConversationsListResponse response = this.slack.methods(this.slackEndpoint.getToken()).conversationsList(req -> req.types(Collections.singletonList(this.slackEndpoint.getConversationType())).cursor(cursor).limit(Integer.valueOf(200)));
            if (!response.isOk()) {
                throw new RuntimeCamelException("API request conversations.list to Slack failed: " + response);
            }
            return response.getChannels().stream().filter(it -> it.getName().equals(channel)).map(Conversation::getId).findFirst().orElseGet(() -> {
                if (ObjectHelper.isEmpty((String)response.getResponseMetadata().getNextCursor())) {
                    throw new RuntimeCamelException(String.format("Channel %s not found", channel));
                }
                return this.getChannelId(channel, response.getResponseMetadata().getNextCursor());
            });
        }
        catch (SlackApiException | IOException e) {
            throw new RuntimeCamelException("API request conversations.list to Slack failed", e);
        }
    }

    private Exchange createExchange(Message object) {
        Exchange exchange = this.createExchange(true);
        exchange.getIn().setBody((Object)object);
        return exchange;
    }
}

