/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import com.slack.api.model.ConversationType;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.slack.SlackComponent;
import org.apache.camel.component.slack.SlackConsumer;
import org.apache.camel.component.slack.SlackProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.16.0", scheme="slack", title="Slack", syntax="slack:channel", category={Category.SOCIAL})
public class SlackEndpoint
extends ScheduledPollEndpoint {
    @UriParam(defaultValue="10000", javaType="java.time.Duration", label="consumer,scheduler", description="Milliseconds before the next poll.")
    private long delay = 10000L;
    @UriPath
    @Metadata(required=true)
    private String channel;
    @UriParam(label="producer")
    private String webhookUrl;
    @UriParam(label="producer", secret=true)
    @Deprecated
    private String username;
    @UriParam(label="producer")
    @Deprecated
    private String iconUrl;
    @UriParam(label="producer")
    @Deprecated
    private String iconEmoji;
    @UriParam(secret=true)
    private String token;
    @UriParam(label="consumer", defaultValue="10")
    private String maxResults = "10";
    @UriParam(label="consumer", defaultValue="https://slack.com")
    private String serverUrl = "https://slack.com";
    @UriParam(label="consumer", defaultValue="false", javaType="boolean", description="Create exchanges in natural order (oldest to newest) or not")
    private boolean naturalOrder;
    @UriParam(label="consumer", enums="PUBLIC_CHANNEL,PRIVATE_CHANNEL,MPIM,IM", defaultValue="PUBLIC_CHANNEL", description="Type of conversation")
    private ConversationType conversationType = ConversationType.PUBLIC_CHANNEL;

    public SlackEndpoint(String uri, String channelName, SlackComponent component) {
        super(uri, (Component)component);
        this.webhookUrl = component.getWebhookUrl();
        this.token = component.getToken();
        this.channel = channelName;
        this.setDelay(10000L);
    }

    public Producer createProducer() throws Exception {
        if (ObjectHelper.isEmpty((String)this.token) && ObjectHelper.isEmpty((String)this.webhookUrl)) {
            throw new RuntimeCamelException("Missing required endpoint configuration: token or webhookUrl must be defined for Slack producer");
        }
        return new SlackProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((String)this.token)) {
            throw new RuntimeCamelException("Missing required endpoint configuration: token must be defined for Slack consumer");
        }
        if (ObjectHelper.isEmpty((String)this.channel)) {
            throw new RuntimeCamelException("Missing required endpoint configuration: channel must be defined for Slack consumer");
        }
        SlackConsumer consumer = new SlackConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public void setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(String maxResult) {
        this.maxResults = maxResult;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setNaturalOrder(boolean naturalOrder) {
        this.naturalOrder = naturalOrder;
    }

    public boolean isNaturalOrder() {
        return this.naturalOrder;
    }

    public void setConversationType(ConversationType conversationType) {
        this.conversationType = conversationType;
    }

    public ConversationType getConversationType() {
        return this.conversationType;
    }

    public void setDelay(long delay) {
        super.setDelay(delay);
        this.delay = delay;
    }
}

