/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

public final class DestinationNameParser {
    private DestinationNameParser() {
    }

    public static boolean isTopic(String destinationName) {
        if (destinationName == null) {
            throw new IllegalArgumentException("destinationName is null");
        }
        return destinationName.startsWith("topic:");
    }

    public static boolean isReplyToTopic(String replyTo, boolean isDestinationTopic) {
        if (replyTo == null) {
            throw new IllegalArgumentException("replyTo is null");
        }
        if (replyTo.startsWith("topic:")) {
            return true;
        }
        if (replyTo.startsWith("queue:")) {
            return false;
        }
        return isDestinationTopic;
    }

    public static String getShortName(String destinationName) {
        if (destinationName == null) {
            throw new IllegalArgumentException("destinationName is null");
        }
        if (destinationName.startsWith("queue:")) {
            return destinationName.substring(6);
        }
        if (destinationName.startsWith("topic:")) {
            return destinationName.substring(6);
        }
        return destinationName;
    }
}

