/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import javax.jms.Connection;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.sjms.MessageListenerContainer;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SjmsConsumer
extends DefaultConsumer
implements Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(SjmsConsumer.class);
    private volatile boolean initialized;
    private final MessageListenerContainer listenerContainer;

    public SjmsConsumer(Endpoint endpoint, Processor processor, MessageListenerContainer listenerContainer) {
        super(endpoint, processor);
        this.listenerContainer = listenerContainer;
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().isAsyncStartListener()) {
            this.getEndpoint().getAsyncStartStopExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        SjmsConsumer.this.prepareAndStartListenerContainer();
                    }
                    catch (Exception e) {
                        LOG.warn("Error starting listener container on destination: {}. This exception will be ignored.", (Object)SjmsConsumer.this.getDestinationName(), (Object)e);
                    }
                }

                public String toString() {
                    return "AsyncStartListenerTask[" + SjmsConsumer.this.getDestinationName() + "]";
                }
            });
        } else {
            this.prepareAndStartListenerContainer();
        }
        this.initialized = true;
    }

    protected void doStop() throws Exception {
        if (this.listenerContainer != null) {
            if (this.getEndpoint().isAsyncStopListener()) {
                this.getEndpoint().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsConsumer.this.stopAndDestroyListenerContainer();
                        }
                        catch (Exception e) {
                            LOG.warn("Error stopping listener container on destination: {}. This exception will be ignored.", (Object)SjmsConsumer.this.getDestinationName(), (Object)e);
                        }
                    }

                    public String toString() {
                        return "AsyncStopListenerTask[" + SjmsConsumer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.stopAndDestroyListenerContainer();
            }
        }
        super.doStop();
    }

    protected void prepareAndStartListenerContainer() {
        this.listenerContainer.afterPropertiesConfigured(this.getEndpoint().getCamelContext());
        if (this.initialized || this.getEndpoint().isAutoStartup()) {
            if (this.getEndpoint().isTestConnectionOnStartup()) {
                this.testConnectionOnStartup();
            }
            this.startListenerContainer();
        }
    }

    protected void testConnectionOnStartup() throws FailedToCreateConsumerException {
        try {
            LOG.debug("Testing JMS Connection on startup for destination: {}", (Object)this.getDestinationName());
            Connection con = this.listenerContainer.getConnectionFactory().createConnection();
            SjmsHelper.closeConnection(con);
            LOG.debug("Successfully tested JMS Connection on startup for destination: {}", (Object)this.getDestinationName());
        }
        catch (Exception e) {
            String msg = "Cannot get JMS Connection on startup for destination " + this.getDestinationName();
            throw new FailedToCreateConsumerException((Endpoint)this.getEndpoint(), msg, (Throwable)e);
        }
    }

    private String getDestinationName() {
        return this.getEndpoint().getDestinationName();
    }

    public void startListenerContainer() {
        LOG.trace("Starting listener container {} on destination {}", (Object)this.listenerContainer, (Object)this.getDestinationName());
        ServiceHelper.startService((Object)this.listenerContainer);
        LOG.debug("Started listener container {} on destination {}", (Object)this.listenerContainer, (Object)this.getDestinationName());
    }

    protected void stopAndDestroyListenerContainer() {
        if (this.listenerContainer != null) {
            ServiceHelper.stopAndShutdownService((Object)this.listenerContainer);
        }
        this.initialized = false;
    }
}

