/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.util.ObjectHelper;

public class ServiceNowDispatcher {
    private final Predicate<Exchange> predicate;
    private final Processor delegate;

    public ServiceNowDispatcher(Predicate<Exchange> predicate, Processor delegate) {
        this.predicate = (Predicate)ObjectHelper.notNull(predicate, (String)"predicate");
        this.delegate = (Processor)ObjectHelper.notNull((Object)delegate, (String)"delegate");
    }

    public boolean match(Exchange exchange) {
        return this.predicate.test(exchange);
    }

    public void process(Exchange exchange) throws Exception {
        this.delegate.process(exchange);
    }

    public static ServiceNowDispatcher on(String action, String subject, Processor delegate) {
        return new ServiceNowDispatcher(e -> ServiceNowDispatcher.matches(e.getIn(), action, subject), delegate);
    }

    public static boolean matches(Message in, String action, String subject) {
        return ObjectHelper.equal((Object)action, (Object)in.getHeader("CamelServiceNowAction", String.class), (boolean)true) && ObjectHelper.equal((Object)subject, (Object)in.getHeader("CamelServiceNowActionSubject", String.class), (boolean)true);
    }
}

