/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.ServiceNowException;
import org.apache.camel.component.servicenow.ServiceNowExceptionModel;
import org.apache.camel.component.servicenow.ServiceNowParam;
import org.apache.camel.component.servicenow.annotations.ServiceNowSysParm;
import org.apache.camel.component.servicenow.auth.AuthenticationRequestFilter;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceNowClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceNowClient.class);
    private final ServiceNowConfiguration configuration;
    private final WebClient client;

    public ServiceNowClient(CamelContext camelContext, ServiceNowConfiguration configuration) {
        this.configuration = configuration;
        this.client = WebClient.create((String)configuration.getApiUrl(), Arrays.asList(new AuthenticationRequestFilter(configuration), new JacksonJsonProvider(configuration.getOrCreateMapper())), (boolean)true);
        ServiceNowClient.configureRequestContext(this.client);
        ServiceNowClient.configureTls(camelContext, configuration, this.client);
        ServiceNowClient.configureHttpClientPolicy(configuration, this.client);
        ServiceNowClient.configureProxyAuthorizationPolicy(configuration, this.client);
    }

    public ServiceNowClient types(MediaType type) {
        return this.types(type, type);
    }

    public ServiceNowClient types(MediaType accept, MediaType type) {
        this.client.accept(new MediaType[]{accept});
        this.client.type(type);
        return this;
    }

    public ServiceNowClient path(Object path) {
        if (ObjectHelper.isNotEmpty((Object)path)) {
            this.client.path(path);
        }
        return this;
    }

    public ServiceNowClient type(MediaType ct) {
        this.client.type(ct);
        return this;
    }

    public ServiceNowClient type(String type) {
        this.client.type(type);
        return this;
    }

    public ServiceNowClient accept(MediaType ... types) {
        this.client.accept(types);
        return this;
    }

    public ServiceNowClient accept(String ... types) {
        this.client.accept(types);
        return this;
    }

    public ServiceNowClient query(String name, Object ... values) {
        this.client.query(name, values);
        return this;
    }

    public ServiceNowClient queryF(String name, String format, Object ... values) {
        this.client.query(name, new Object[]{String.format(format, values)});
        return this;
    }

    public ServiceNowClient query(ServiceNowParam param, Message message) {
        Object value = param.getHeaderValue(message, this.configuration);
        if (value != null) {
            this.client.query(param.getId(), new Object[]{value});
        }
        return this;
    }

    public ServiceNowClient query(Class<?> model) {
        if (model != null) {
            for (ServiceNowSysParm parm : (ServiceNowSysParm[])model.getAnnotationsByType(ServiceNowSysParm.class)) {
                String name = parm.name();
                String value = parm.value();
                if (!ObjectHelper.isNotEmpty((String)name) || !ObjectHelper.isNotEmpty((String)value)) continue;
                LOGGER.debug("Replace query param {} with value {}", (Object)name, (Object)value);
                this.client.replaceQueryParam(name, new Object[]{value});
            }
        }
        return this;
    }

    public Response invoke(String httpMethod) throws Exception {
        return this.invoke(this.client, httpMethod, null);
    }

    public Response invoke(String httpMethod, Object body) throws Exception {
        return this.invoke(this.client, httpMethod, body);
    }

    public <T> T trasform(String httpMethod, Function<Response, T> function) throws Exception {
        return function.apply(this.invoke(this.client, httpMethod, null));
    }

    public <T> T trasform(String httpMethod, Object body, Function<Response, T> function) throws Exception {
        return function.apply(this.invoke(this.client, httpMethod, body));
    }

    public ServiceNowClient reset() {
        this.client.back(true);
        this.client.reset();
        this.client.resetQuery();
        return this;
    }

    private Response invoke(WebClient client, String httpMethod, Object body) throws Exception {
        Response response = client.invoke(httpMethod, body);
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 201: 
            case 204: {
                break;
            }
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 415: {
                ServiceNowExceptionModel model = (ServiceNowExceptionModel)response.readEntity(ServiceNowExceptionModel.class);
                throw new ServiceNowException(code, model.getStatus(), model.getError().get("message"), model.getError().get("detail"));
            }
            default: {
                throw new ServiceNowException(code, (Map)response.readEntity(Map.class));
            }
        }
        return response;
    }

    private static void configureRequestContext(WebClient client) {
        WebClient.getConfig((Object)client).getRequestContext().put("org.apache.cxf.http.header.split", true);
    }

    private static void configureTls(CamelContext camelContext, ServiceNowConfiguration configuration, WebClient client) {
        SSLContextParameters sslContextParams = configuration.getSslContextParameters();
        if (sslContextParams != null) {
            HTTPConduit conduit = WebClient.getConfig((Object)client).getHttpConduit();
            TLSClientParameters tlsClientParams = conduit.getTlsClientParameters();
            if (tlsClientParams == null) {
                tlsClientParams = new TLSClientParameters();
            }
            try {
                SSLContext sslContext = sslContextParams.createSSLContext(camelContext);
                tlsClientParams.setSSLSocketFactory(sslContext.getSocketFactory());
                conduit.setTlsClientParameters(tlsClientParams);
            }
            catch (IOException | GeneralSecurityException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    private static void configureHttpClientPolicy(ServiceNowConfiguration configuration, WebClient client) {
        HTTPClientPolicy httpPolicy = configuration.getHttpClientPolicy();
        if (httpPolicy == null) {
            String host = configuration.getProxyHost();
            Integer port = configuration.getProxyPort();
            if (host != null && port != null) {
                httpPolicy = new HTTPClientPolicy();
                httpPolicy.setProxyServer(host);
                httpPolicy.setProxyServerPort(port);
            }
        }
        if (httpPolicy != null) {
            WebClient.getConfig((Object)client).getHttpConduit().setClient(httpPolicy);
        }
    }

    private static void configureProxyAuthorizationPolicy(ServiceNowConfiguration configuration, WebClient client) {
        ProxyAuthorizationPolicy proxyPolicy = configuration.getProxyAuthorizationPolicy();
        if (proxyPolicy == null) {
            String username = configuration.getProxyUserName();
            String password = configuration.getProxyPassword();
            if (username != null && password != null) {
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setAuthorizationType("Basic");
                proxyPolicy.setUserName(username);
                proxyPolicy.setPassword(password);
            }
        }
        if (proxyPolicy != null) {
            WebClient.getConfig((Object)client).getHttpConduit().setProxyAuthorization(proxyPolicy);
        }
    }
}

