/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.releases.helsinki;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.servicenow.AbstractServiceNowProcessor;
import org.apache.camel.component.servicenow.ServiceNowEndpoint;
import org.apache.camel.component.servicenow.ServiceNowParams;
import org.apache.camel.util.ObjectHelper;

public class HelsinkiServiceNowAttachmentProcessor
extends AbstractServiceNowProcessor {
    protected HelsinkiServiceNowAttachmentProcessor(ServiceNowEndpoint endpoint) throws Exception {
        super(endpoint);
        this.addDispatcher("retrieve", this::retrieveMeta);
        this.addDispatcher("content", this::retrieveContent);
        this.addDispatcher("upload", this::uploadContent);
        this.addDispatcher("delete", this::deleteContent);
    }

    private void retrieveMeta(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        Response response = ObjectHelper.isEmpty((String)sysId) ? this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("attachment").query(ServiceNowParams.SYSPARM_QUERY, in).query(ServiceNowParams.SYSPARM_LIMIT, in).query(ServiceNowParams.SYSPARM_OFFSET, in).query(ServiceNowParams.SYSPARM_SUPPRESS_PAGINATION_HEADER, in).invoke("GET") : this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("attachment").path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).invoke("GET");
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void retrieveContent(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String apiVersion = this.getApiVersion(in);
        String sysId = this.getSysID(in);
        Response response = this.client.reset().type(MediaType.APPLICATION_JSON_TYPE).accept("*/*").path("now").path(apiVersion).path("attachment").path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).path("file").invoke("GET");
        this.setHeaders(in, null, response);
        in.setBody(response.readEntity(InputStream.class));
    }

    private void uploadContent(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        Response response = this.client.reset().type((String)ObjectHelper.notNull((Object)((String)in.getHeader("CamelServiceNowContentType", String.class)), (String)"CamelServiceNowContentType")).accept(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("attachment").path("file").query(ServiceNowParams.PARAM_FILE_NAME, in).query(ServiceNowParams.PARAM_TABLE_NAME, in).query(ServiceNowParams.PARAM_TABLE_SYS_ID, in).query(ServiceNowParams.PARAM_ENCRYPTION_CONTEXT, in).query(responseModel).invoke("POST", in.getMandatoryBody(InputStream.class));
        this.setBodyAndHeaders(in, responseModel, response);
    }

    private void deleteContent(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String tableName = this.getTableName(in);
        String apiVersion = this.getApiVersion(in);
        Class<?> responseModel = this.getResponseModel(in, tableName);
        String sysId = this.getSysID(in);
        Response response = this.client.reset().types(MediaType.APPLICATION_JSON_TYPE).path("now").path(apiVersion).path("attachment").path(ObjectHelper.notNull((Object)sysId, (String)"sysId")).query(responseModel).invoke("DELETE");
        this.setBodyAndHeaders(in, responseModel, response);
    }
}

