/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servicenow.auth;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.camel.component.servicenow.ServiceNowConfiguration;
import org.apache.camel.component.servicenow.auth.OAuthToken;

@Provider
@Priority(value=1000)
public final class AuthenticationRequestFilter
implements ClientRequestFilter {
    private final OAuthToken authToken;
    private final String authString;

    public AuthenticationRequestFilter(ServiceNowConfiguration conf) {
        this.authToken = conf.hasOAuthAuthentication() ? new OAuthToken(conf) : null;
        this.authString = conf.hasBasicAuthentication() ? AuthenticationRequestFilter.getBasicAuthenticationString(conf) : null;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (this.authToken != null) {
            requestContext.getHeaders().add((Object)"Authorization", (Object)this.authToken.getAuthString());
        } else if (this.authString != null) {
            requestContext.getHeaders().add((Object)"Authorization", (Object)this.authString);
        }
    }

    private static String getBasicAuthenticationString(ServiceNowConfiguration conf) {
        String userAndPassword = conf.getUserName() + ":" + conf.getPassword();
        return "Basic " + Base64.getEncoder().encodeToString(userAndPassword.getBytes(StandardCharsets.UTF_8));
    }
}

