/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.scr;

import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScrHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ScrHelper.class);

    private ScrHelper() {
    }

    public static Map<String, String> getScrProperties(String componentName) throws Exception {
        return ScrHelper.getScrProperties(String.format("target/classes/OSGI-INF/%s.xml", componentName), componentName);
    }

    public static Map<String, String> getScrProperties(String xmlLocation, String componentName) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
        XMLEventReader eventReader = inputFactory.createXMLEventReader(new FileReader(xmlLocation));
        boolean collect = false;
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.getEventType() == 1 && event.asStartElement().getName().toString().equals("scr:component") && event.asStartElement().getAttributeByName(QName.valueOf("name")).getValue().equals(componentName)) {
                collect = true;
                continue;
            }
            if (collect && event.getEventType() == 1 && event.asStartElement().getName().toString().equals("property")) {
                result.put(event.asStartElement().getAttributeByName(QName.valueOf("name")).getValue(), event.asStartElement().getAttributeByName(QName.valueOf("value")).getValue());
                continue;
            }
            if (!collect || event.getEventType() != 2 || !event.asEndElement().getName().toString().equals("scr:component")) continue;
            break;
        }
        return result;
    }
}

