/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.camel.Endpoint;
import org.apache.camel.component.scheduler.SchedulerConsumer;
import org.apache.camel.component.scheduler.SchedulerEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;

@Component(value="scheduler")
public class SchedulerComponent
extends HealthCheckComponent {
    private final Map<String, ScheduledExecutorServiceHolder> executors = new ConcurrentHashMap<String, ScheduledExecutorServiceHolder>();
    @Metadata
    private boolean includeMetadata;
    @Metadata(defaultValue="1", label="scheduler")
    private int poolSize = 1;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SchedulerEndpoint answer = new SchedulerEndpoint(uri, this, remaining);
        answer.setIncludeMetadata(this.isIncludeMetadata());
        answer.setPoolSize(this.getPoolSize());
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    protected ScheduledExecutorService addConsumer(SchedulerConsumer consumer) {
        String name = consumer.getEndpoint().getName();
        return this.executors.compute((String)name, (BiFunction<String, ScheduledExecutorServiceHolder, ScheduledExecutorServiceHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$addConsumer$0(org.apache.camel.component.scheduler.SchedulerConsumer java.lang.String java.lang.String org.apache.camel.component.scheduler.SchedulerComponent$ScheduledExecutorServiceHolder ), (Ljava/lang/String;Lorg/apache/camel/component/scheduler/SchedulerComponent$ScheduledExecutorServiceHolder;)Lorg/apache/camel/component/scheduler/SchedulerComponent$ScheduledExecutorServiceHolder;)((SchedulerComponent)this, (SchedulerConsumer)consumer, (String)name)).executorService;
    }

    protected void removeConsumer(SchedulerConsumer consumer) {
        String name = consumer.getEndpoint().getName();
        this.executors.computeIfPresent(name, (k, v) -> {
            if (v.refCount.decrementAndGet() == 0) {
                this.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)v.executorService);
                return null;
            }
            return v;
        });
    }

    protected void doStop() throws Exception {
        Collection<ScheduledExecutorServiceHolder> collection = this.executors.values();
        for (ScheduledExecutorServiceHolder holder : collection) {
            this.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)holder.executorService);
        }
        this.executors.clear();
    }

    private /* synthetic */ ScheduledExecutorServiceHolder lambda$addConsumer$0(SchedulerConsumer consumer, String name, String k, ScheduledExecutorServiceHolder v) {
        if (v == null) {
            int poolSize = consumer.getEndpoint().getPoolSize();
            return new ScheduledExecutorServiceHolder(this.getCamelContext().getExecutorServiceManager().newScheduledThreadPool((Object)this, "scheduler://" + name, poolSize));
        }
        v.refCount.incrementAndGet();
        return v;
    }

    private static class ScheduledExecutorServiceHolder {
        private final ScheduledExecutorService executorService;
        private final AtomicInteger refCount;

        ScheduledExecutorServiceHolder(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            this.refCount = new AtomicInteger(1);
        }
    }
}

