/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.lang.annotation.Annotation;
import net.sf.saxon.functions.CollectionFn;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.xquery.ResultFormat;
import org.apache.camel.component.xquery.XQuery;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.support.language.NamespacePrefix;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Node;

public class XQueryAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        Class<Object> resultType;
        String xQuery = this.getExpressionFromAnnotation(annotation);
        XQueryBuilder builder = XQueryBuilder.xquery(xQuery);
        if (annotation instanceof XQuery) {
            NamespacePrefix[] namespaces;
            XQuery xQueryAnnotation = (XQuery)annotation;
            builder.setStripsAllWhiteSpace(xQueryAnnotation.stripsAllWhiteSpace());
            String variableName = null;
            String headerName = null;
            String propertyName = null;
            if (ObjectHelper.isNotEmpty((String)xQueryAnnotation.variableName())) {
                variableName = xQueryAnnotation.variableName();
            }
            if (ObjectHelper.isNotEmpty((String)xQueryAnnotation.headerName())) {
                headerName = xQueryAnnotation.headerName();
            }
            if (ObjectHelper.isNotEmpty((String)xQueryAnnotation.propertyName())) {
                propertyName = xQueryAnnotation.propertyName();
            }
            if (variableName != null || headerName != null || propertyName != null) {
                builder.setSource(ExpressionBuilder.singleInputExpression((String)variableName, (String)headerName, (String)propertyName));
            }
            if ((namespaces = xQueryAnnotation.namespaces()) != null) {
                for (NamespacePrefix namespacePrefix : namespaces) {
                    builder = builder.namespace(namespacePrefix.prefix(), namespacePrefix.uri());
                }
            }
        }
        if ((resultType = this.getResultType(annotation)).equals(Object.class)) {
            resultType = expressionReturnType;
        }
        if (resultType.isAssignableFrom(String.class)) {
            builder.setResultsFormat(ResultFormat.String);
        } else if (resultType.isAssignableFrom(CollectionFn.class)) {
            builder.setResultsFormat(ResultFormat.List);
        } else if (resultType.isAssignableFrom(Node.class)) {
            builder.setResultsFormat(ResultFormat.DOM);
        } else if (resultType.isAssignableFrom(byte[].class)) {
            builder.setResultsFormat(ResultFormat.Bytes);
        }
        return builder;
    }

    protected Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }
}

