/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.camel.component.salesforce.api.dto.AbstractDescribedSObjectBase;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SObjectField;

public final class QueryHelper {
    private static final String[] NONE = new String[0];

    private QueryHelper() {
    }

    public static String[] fieldNamesOf(AbstractDescribedSObjectBase object) {
        if (object == null) {
            return NONE;
        }
        SObjectDescription description = object.description();
        List<SObjectField> fields = description.getFields();
        return (String[])fields.stream().map(SObjectField::getName).toArray(String[]::new);
    }

    public static String[] filteredFieldNamesOf(AbstractDescribedSObjectBase object, Predicate<SObjectField> filter) {
        if (object == null) {
            return NONE;
        }
        if (filter == null) {
            return QueryHelper.fieldNamesOf(object);
        }
        SObjectDescription description = object.description();
        List<SObjectField> fields = description.getFields();
        return (String[])fields.stream().filter(filter).map(SObjectField::getName).toArray(String[]::new);
    }

    public static String queryToFetchAllFieldsOf(AbstractDescribedSObjectBase object) {
        if (object == null) {
            return null;
        }
        SObjectDescription description = object.description();
        List<SObjectField> fields = description.getFields();
        return fields.stream().map(SObjectField::getName).collect(Collectors.joining(", ", "SELECT ", " FROM " + description.getName()));
    }

    public static String queryToFetchFilteredFieldsOf(AbstractDescribedSObjectBase object, Predicate<SObjectField> filter) {
        if (object == null) {
            return null;
        }
        if (filter == null) {
            return QueryHelper.queryToFetchAllFieldsOf(object);
        }
        SObjectDescription description = object.description();
        List<SObjectField> fields = description.getFields();
        return fields.stream().filter(filter).map(SObjectField::getName).collect(Collectors.joining(", ", "SELECT ", " FROM " + description.getName()));
    }
}

